/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.ChannelWriteCompleteListenableFuture;
import com.navercorp.pinpoint.rpc.ChannelWriteFailListenableFuture;
import com.navercorp.pinpoint.rpc.DefaultFuture;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.ConnectFuture;
import com.navercorp.pinpoint.rpc.client.ConnectionFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandlerContext;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandlerState;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandshaker;
import com.navercorp.pinpoint.rpc.client.RequestManager;
import com.navercorp.pinpoint.rpc.client.SimpleMessageListener;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.common.SocketStateChangeResult;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import com.navercorp.pinpoint.rpc.packet.ClientClosePacket;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakeResponsePacket;
import com.navercorp.pinpoint.rpc.packet.HandshakeResponseCode;
import com.navercorp.pinpoint.rpc.packet.Packet;
import com.navercorp.pinpoint.rpc.packet.PingPayloadPacket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.ResponsePacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.StreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.StreamChannelManager;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.util.ClassUtils;
import com.navercorp.pinpoint.rpc.util.IDGenerator;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPinpointClientHandler
extends SimpleChannelHandler
implements PinpointClientHandler {
    private static final String WRITE_BUFFER_FULL_MESSAGE = "write buffer is full";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger pingIdGenerator;
    private final PinpointClientHandlerState state;
    private final SocketAddressProvider socketAddressProvider;
    private volatile Channel channel;
    private final Timer channelTimer;
    private final ConnectionFactory connectionFactory;
    private volatile PinpointClient pinpointClient;
    private final MessageListener messageListener;
    private final ServerStreamChannelMessageListener serverStreamChannelMessageListener;
    private final RequestManager requestManager;
    private final ChannelFutureListener pingWriteFailFutureListener = new WriteFailFutureListener(this.logger, "ping write fail.", "ping write success.");
    private final ChannelFutureListener sendWriteFailFutureListener = new WriteFailFutureListener(this.logger, "send() write fail.", "send() write success.");
    private final ChannelFutureListener sendClosePacketFailFutureListener = new WriteFailFutureListener(this.logger, "sendClosedPacket() write fail.", "sendClosedPacket() write success.");
    private final PinpointClientHandshaker handshaker;
    private final ConnectFuture connectFuture = new ConnectFuture();
    private final String objectUniqName;
    private final ClientOption clientOption;
    private final ClusterOption localClusterOption;
    private volatile ClusterOption remoteClusterOption = ClusterOption.DISABLE_CLUSTER_OPTION;

    public DefaultPinpointClientHandler(ConnectionFactory connectionFactory, SocketAddressProvider socketAddressProvider, PinpointClientHandshaker handshaker, ClusterOption localClusterOption, ClientOption clientOption, Timer channelTimer, MessageListener messageListener, ServerStreamChannelMessageListener serverStreamChannelMessageListener, List<StateChangeEventListener> stateChangeEventListeners) {
        this.connectionFactory = (ConnectionFactory)Assert.requireNonNull((Object)connectionFactory, (String)"clientFactory must not be null");
        this.socketAddressProvider = (SocketAddressProvider)Assert.requireNonNull((Object)socketAddressProvider, (String)"socketAddressProvider must not be null");
        this.channelTimer = (Timer)Assert.requireNonNull((Object)channelTimer, (String)"channelTimer must not be null");
        this.requestManager = new RequestManager(channelTimer, clientOption.getRequestTimeoutMillis());
        this.clientOption = (ClientOption)Assert.requireNonNull((Object)clientOption, (String)"clientOption must not be null");
        this.messageListener = (MessageListener)Assert.requireNonNull((Object)messageListener, (String)"messageListener must not be null");
        this.serverStreamChannelMessageListener = (ServerStreamChannelMessageListener)Assert.requireNonNull((Object)serverStreamChannelMessageListener, (String)"serverStreamChannelMessageListener must not be null");
        this.objectUniqName = ClassUtils.simpleClassNameAndHashCodeString(this);
        this.handshaker = (PinpointClientHandshaker)Assert.requireNonNull((Object)handshaker, (String)"handshaker must not be null");
        this.pingIdGenerator = new AtomicInteger(0);
        this.state = new PinpointClientHandlerState(this.objectUniqName, this, stateChangeEventListeners);
        this.localClusterOption = (ClusterOption)Assert.requireNonNull((Object)localClusterOption, (String)"clusterOption must not be null");
    }

    @Override
    public void setPinpointClient(PinpointClient pinpointClient) {
        if (pinpointClient == null) {
            throw new NullPointerException("pinpointClient must not be null");
        }
        this.pinpointClient = pinpointClient;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        this.logger.debug("{} channelOpen() started. channel:{}", (Object)this.objectUniqName, (Object)channel);
        this.channel = channel;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (null == channel || this.channel != channel) {
            throw new IllegalArgumentException("Invalid channel variable. this.channel:" + this.channel + ", channel:" + channel + ".");
        }
        this.logger.info("{} channelConnected() started. channel:{}", (Object)this.objectUniqName, (Object)channel);
        SocketStateChangeResult stateChangeResult = this.state.toConnected();
        if (!stateChangeResult.isChange()) {
            throw new IllegalStateException("Invalid state:" + (Object)((Object)stateChangeResult.getCurrentState()));
        }
        this.prepareChannel(channel);
        stateChangeResult = this.state.toRunWithoutHandshake();
        if (!stateChangeResult.isChange()) {
            throw new IllegalStateException("Failed to execute channelConnected() method. Error:" + stateChangeResult);
        }
        this.registerPing();
        this.handshaker.handshakeStart(channel);
        this.connectFuture.setResult(ConnectFuture.Result.SUCCESS);
        this.logger.info("{} channelConnected() completed.", (Object)this.objectUniqName);
    }

    private void prepareChannel(Channel channel) {
        StreamChannelManager streamChannelManager = new StreamChannelManager(channel, IDGenerator.createOddIdGenerator(), this.serverStreamChannelMessageListener);
        PinpointClientHandlerContext context = new PinpointClientHandlerContext(channel, streamChannelManager);
        channel.setAttachment((Object)context);
    }

    @Override
    public void initReconnect() {
        this.logger.info("{} initReconnect() started.", (Object)this.objectUniqName);
        SocketStateChangeResult stateChangeResult = this.state.toBeingConnect();
        if (!stateChangeResult.isChange()) {
            throw new IllegalStateException("Failed to execute initReconnect() method. Error:" + stateChangeResult);
        }
        this.logger.info("{} initReconnect() completed.", (Object)this.objectUniqName);
    }

    private void registerPing() {
        PingTask pingTask = new PingTask();
        this.newPingTimeout(pingTask);
    }

    private void newPingTimeout(TimerTask pingTask) {
        this.channelTimer.newTimeout(pingTask, this.clientOption.getPingDelay(), TimeUnit.MILLISECONDS);
    }

    void writePing() {
        if (!this.state.isEnableCommunication()) {
            return;
        }
        this.logger.debug("{} writePing() started. channel:{}", (Object)this.objectUniqName, (Object)this.channel);
        PingPayloadPacket pingPacket = new PingPayloadPacket(this.pingIdGenerator.incrementAndGet(), 0, this.state.getCurrentStateCode().getId());
        this.write0(pingPacket, this.pingWriteFailFutureListener);
    }

    @Override
    public void sendPing() {
        if (!this.state.isEnableCommunication()) {
            return;
        }
        this.logger.debug("{} sendPing() started.", (Object)this.objectUniqName);
        PingPayloadPacket pingPacket = new PingPayloadPacket(this.pingIdGenerator.incrementAndGet(), 0, this.state.getCurrentStateCode().getId());
        ChannelFuture future = this.write0(pingPacket);
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            Throwable cause = future.getCause();
            throw new PinpointSocketException("send ping failed. Error:" + cause.getMessage(), cause);
        }
        this.logger.debug("{} sendPing() completed.", (Object)this.objectUniqName);
    }

    @Override
    public void send(byte[] bytes) {
        ChannelFuture future = this.send0(bytes);
        future.addListener(this.sendWriteFailFutureListener);
    }

    @Override
    public Future sendAsync(byte[] bytes) {
        ChannelFuture channelFuture = this.send0(bytes);
        ChannelWriteCompleteListenableFuture future = new ChannelWriteCompleteListenableFuture(this.clientOption.getWriteTimeoutMillis());
        channelFuture.addListener(future);
        return future;
    }

    @Override
    public void sendSync(byte[] bytes) {
        ChannelFuture write = this.send0(bytes);
        this.await(write);
    }

    @Override
    public void response(int requestId, byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("bytes");
        }
        this.ensureOpen();
        ResponsePacket response = new ResponsePacket(requestId, payload);
        this.write0(response);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        Channel channel = this.channel;
        if (channel == null) {
            return null;
        }
        return channel.getRemoteAddress();
    }

    private void await(ChannelFuture channelFuture) {
        try {
            channelFuture.await(this.clientOption.getWriteTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (channelFuture.isDone()) {
            boolean success = channelFuture.isSuccess();
            if (success) {
                return;
            }
            Throwable cause = channelFuture.getCause();
            throw new PinpointSocketException(cause);
        }
        boolean cancel = channelFuture.cancel();
        if (cancel) {
            throw new PinpointSocketException("io timeout");
        }
        boolean success = channelFuture.isSuccess();
        if (success) {
            return;
        }
        Throwable cause = channelFuture.getCause();
        throw new PinpointSocketException(cause);
    }

    private ChannelFuture send0(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.ensureOpen();
        SendPacket send = new SendPacket(bytes);
        return this.write0(send);
    }

    @Override
    public Future<ResponseMessage> request(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        boolean isEnable = this.state.isEnableCommunication();
        if (!isEnable) {
            DefaultFuture<ResponseMessage> closedException = new DefaultFuture<ResponseMessage>();
            closedException.setFailure(new PinpointSocketException("invalid state:" + (Object)((Object)this.state.getCurrentStateCode()) + " channel:" + this.channel));
            return closedException;
        }
        int requestId = this.requestManager.nextRequestId();
        RequestPacket request = new RequestPacket(requestId, bytes);
        ChannelWriteFailListenableFuture<ResponseMessage> messageFuture = this.requestManager.register(request.getRequestId(), this.clientOption.getRequestTimeoutMillis());
        this.write0(request, messageFuture);
        return messageFuture;
    }

    @Override
    public ClientStreamChannelContext openStream(byte[] payload, ClientStreamChannelMessageListener messageListener) {
        return this.openStream(payload, messageListener, null);
    }

    @Override
    public ClientStreamChannelContext openStream(byte[] payload, ClientStreamChannelMessageListener messageListener, StreamChannelStateChangeEventHandler<ClientStreamChannel> stateChangeListener) {
        this.ensureOpen();
        PinpointClientHandlerContext context = this.getChannelContext(this.channel);
        return context.openStream(payload, messageListener, stateChangeListener);
    }

    @Override
    public StreamChannelContext findStreamChannel(int streamChannelId) {
        this.ensureOpen();
        PinpointClientHandlerContext context = this.getChannelContext(this.channel);
        return context.getStreamChannel(streamChannelId);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object message = e.getMessage();
        if (message instanceof Packet) {
            Packet packet = (Packet)message;
            short packetType = packet.getPacketType();
            switch (packetType) {
                case 6: {
                    this.requestManager.messageReceived((ResponsePacket)message, this.objectUniqName);
                    return;
                }
                case 5: {
                    this.messageListener.handleRequest((RequestPacket)message, this.pinpointClient);
                    return;
                }
                case 1: {
                    this.messageListener.handleSend((SendPacket)message, this.pinpointClient);
                    return;
                }
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: {
                    PinpointClientHandlerContext context = this.getChannelContext(this.channel);
                    context.handleStreamEvent((StreamPacket)message);
                    return;
                }
                case 110: {
                    this.handleClosedPacket(e.getChannel());
                    return;
                }
                case 151: {
                    this.handleHandshakePacket((ControlHandshakeResponsePacket)message, e.getChannel());
                    return;
                }
            }
            this.logger.warn("{} messageReceived() failed. unexpectedMessage received:{} address:{}", new Object[]{this.objectUniqName, message, e.getRemoteAddress()});
        } else {
            this.logger.warn("{} messageReceived() failed. invalid messageReceived:{}", (Object)this.objectUniqName, message);
        }
    }

    private void handleClosedPacket(Channel channel) {
        this.logger.info("{} handleClosedPacket() started. channel:{}", (Object)this.objectUniqName, (Object)channel);
        this.state.toBeingCloseByPeer();
    }

    private void handleHandshakePacket(ControlHandshakeResponsePacket message, Channel channel) {
        boolean isCompleted = this.handshaker.handshakeComplete(message);
        this.logger.info("{} handleHandshakePacket() started. message:{}", (Object)this.objectUniqName, (Object)message);
        if (isCompleted) {
            HandshakeResponseCode code = this.handshaker.getHandshakeResult();
            if (code == HandshakeResponseCode.SUCCESS || code == HandshakeResponseCode.ALREADY_KNOWN) {
                this.state.toRunSimplex();
            } else if (code == HandshakeResponseCode.DUPLEX_COMMUNICATION || code == HandshakeResponseCode.ALREADY_DUPLEX_COMMUNICATION) {
                this.remoteClusterOption = this.handshaker.getClusterOption();
                this.state.toRunDuplex();
            } else if (code == HandshakeResponseCode.SIMPLEX_COMMUNICATION || code == HandshakeResponseCode.ALREADY_SIMPLEX_COMMUNICATION) {
                this.state.toRunSimplex();
            } else {
                this.logger.warn("{} handleHandshakePacket() failed. Error:Invalid Handshake Packet(code:{}).", (Object)this.objectUniqName, (Object)code);
                return;
            }
            this.logger.info("{} handleHandshakePacket() completed. code:{}", (Object)channel, (Object)code);
        } else if (this.handshaker.isFinished()) {
            this.logger.warn("{} handleHandshakePacket() failed. Error:Handshake already completed.");
        } else {
            this.logger.warn("{} handleHandshakePacket() failed. Error:Handshake not yet started.");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        SocketStateCode currentStateCode = this.state.getCurrentStateCode();
        if (currentStateCode == SocketStateCode.BEING_CONNECT) {
            this.logger.info("{} exceptionCaught() occurred. state:{}, caused:{}.", new Object[]{this.objectUniqName, currentStateCode, cause.getMessage()});
        } else if (currentStateCode == SocketStateCode.NONE) {
            this.logger.warn("{} exceptionCaught() occurred. state:{}. Caused:{}", new Object[]{this.objectUniqName, currentStateCode, cause.getMessage(), cause});
            this.connectFuture.setResult(ConnectFuture.Result.FAIL);
        } else {
            this.logger.warn("{} exceptionCaught() occurred. state:{}. Caused:{}", new Object[]{this.objectUniqName, currentStateCode, cause.getMessage(), cause});
        }
    }

    private void ensureOpen() {
        SocketStateCode currentStateCode = this.state.getCurrentStateCode();
        if (this.state.isEnableCommunication(currentStateCode)) {
            return;
        }
        if (this.state.isReconnect(currentStateCode)) {
            throw new PinpointSocketException("reconnecting...");
        }
        throw new PinpointSocketException("Invalid socket state:" + (Object)((Object)currentStateCode));
    }

    @Override
    public void close() {
        this.logger.debug("{} close() started.", (Object)this.objectUniqName);
        SocketStateCode currentStateCode = this.state.getCurrentStateCode();
        if (currentStateCode.isRun()) {
            this.state.toBeingClose();
            this.closeChannel();
        } else if (currentStateCode.isBeforeConnected()) {
            this.state.toClosed();
            this.closeResources();
        } else if (currentStateCode.onClose() || currentStateCode.isClosed()) {
            this.logger.warn("close() failed. Already closed.");
        } else {
            this.logger.warn("Illegal State :{}.", (Object)currentStateCode);
        }
    }

    private void closeChannel() {
        Channel channel = this.channel;
        if (channel != null) {
            this.sendClosedPacket(channel);
            ChannelFuture closeFuture = channel.close();
            closeFuture.addListener((ChannelFutureListener)new WriteFailFutureListener(this.logger, "close() event failed.", "close() event success."));
            closeFuture.awaitUninterruptibly();
        }
    }

    private void closeResources() {
        this.logger.debug("{} closeResources() started.", (Object)this.objectUniqName);
        Channel channel = this.channel;
        this.closeStreamChannelManager(channel);
        this.handshaker.handshakeAbort();
        this.requestManager.close();
        this.channelTimer.stop();
    }

    private void closeStreamChannelManager(Channel channel) {
        if (channel == null) {
            this.logger.debug("channel already set null. skip closeStreamChannelManager().");
            return;
        }
        PinpointClientHandlerContext context = this.getChannelContext(channel);
        if (context != null) {
            context.closeAllStreamChannel();
        }
    }

    private void sendClosedPacket(Channel channel) {
        if (!channel.isConnected()) {
            this.logger.debug("{} sendClosedPacket() failed. Error:channel already closed.", (Object)this.objectUniqName);
            return;
        }
        this.logger.debug("{} sendClosedPacket() started.", (Object)this.objectUniqName);
        ClientClosePacket clientClosePacket = new ClientClosePacket();
        ChannelFuture write = this.write0(clientClosePacket, this.sendClosePacketFailFutureListener);
        write.awaitUninterruptibly(3000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.logger.info("{} channelClosed() started.", (Object)this.objectUniqName);
        try {
            boolean factoryReleased = this.connectionFactory.isClosed();
            boolean needReconnect = false;
            SocketStateCode currentStateCode = this.state.getCurrentStateCode();
            if (currentStateCode == SocketStateCode.BEING_CLOSE_BY_CLIENT) {
                this.state.toClosed();
            } else if (currentStateCode == SocketStateCode.BEING_CLOSE_BY_SERVER) {
                needReconnect = this.state.toClosedByPeer().isChange();
            } else if (currentStateCode.isRun() && factoryReleased) {
                this.state.toUnexpectedClosed();
            } else if (currentStateCode.isRun()) {
                needReconnect = this.state.toUnexpectedClosedByPeer().isChange();
            } else if (currentStateCode.isBeforeConnected()) {
                this.state.toConnectFailed();
            } else {
                this.state.toErrorUnknown();
            }
            if (needReconnect) {
                this.reconnect();
            }
        }
        finally {
            this.closeResources();
            this.connectFuture.setResult(ConnectFuture.Result.FAIL);
        }
    }

    private void reconnect() {
        this.connectionFactory.reconnect(this.pinpointClient, this.socketAddressProvider);
    }

    private ChannelFuture write0(Object message, ChannelFutureListener futureListener) {
        if (futureListener == null) {
            throw new NullPointerException("futureListener must not be null");
        }
        ChannelFuture future = this.write0(message);
        future.addListener(futureListener);
        return future;
    }

    private ChannelFuture write0(Object message) {
        if (this.channel.isWritable()) {
            return this.channel.write(message);
        }
        return Channels.failedFuture((Channel)this.channel, (Throwable)new ChannelException(WRITE_BUFFER_FULL_MESSAGE));
    }

    @Override
    public ConnectFuture getConnectFuture() {
        return this.connectFuture;
    }

    @Override
    public SocketStateCode getCurrentStateCode() {
        return this.state.getCurrentStateCode();
    }

    private PinpointClientHandlerContext getChannelContext(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel must not be null");
        }
        return (PinpointClientHandlerContext)channel.getAttachment();
    }

    @Override
    public boolean isConnected() {
        return this.state.isEnableCommunication();
    }

    @Override
    public boolean isSupportServerMode() {
        return this.messageListener != SimpleMessageListener.INSTANCE;
    }

    @Override
    public ClusterOption getLocalClusterOption() {
        return this.localClusterOption;
    }

    @Override
    public ClusterOption getRemoteClusterOption() {
        return this.remoteClusterOption;
    }

    protected PinpointSocket getPinpointSocket() {
        return this.pinpointClient;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.objectUniqName);
        sb.append('{');
        sb.append("channel=").append(this.channel);
        sb.append("state=").append(this.state);
        sb.append('}');
        return sb.toString();
    }

    private class PingTask
    implements TimerTask {
        private PingTask() {
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                DefaultPinpointClientHandler.this.newPingTimeout(this);
                return;
            }
            if (DefaultPinpointClientHandler.this.state.isClosed()) {
                return;
            }
            DefaultPinpointClientHandler.this.writePing();
            DefaultPinpointClientHandler.this.newPingTimeout(this);
        }
    }
}

