/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStateChangeEventListener
implements StateChangeEventListener<PinpointSocket> {
    public static final LoggingStateChangeEventListener INSTANCE = new LoggingStateChangeEventListener();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void eventPerformed(PinpointSocket pinpointSocket, SocketStateCode stateCode) throws Exception {
        this.logger.info("eventPerformed socket:{}, stateCode:{}", (Object)pinpointSocket, (Object)stateCode);
    }

    @Override
    public void exceptionCaught(PinpointSocket pinpointSocket, SocketStateCode stateCode, Throwable e) {
        this.logger.warn("exceptionCaught message:{}, socket:{}, stateCode:{}", new Object[]{e.getMessage(), pinpointSocket, stateCode, e});
    }
}

