/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPathResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ProjectPath resolvePathFromTestClass(Class testClass) {
        if (testClass == null) {
            throw new NullPointerException("testClass must not be null");
        }
        String testClassDir = this.getTestClassPath(testClass);
        String targetPath = this.getTargetPath(testClassDir);
        String modulePath = this.getModulePath(targetPath);
        String projectPath = this.getProjectPath(modulePath);
        String pinpointAgentPath = this.getPinpointAgentPath(projectPath);
        return new ProjectPath(testClassDir, targetPath, modulePath, projectPath, pinpointAgentPath);
    }

    private String getTestClassPath(Class<?> testClass) {
        this.logger.debug("testClass:{}", testClass);
        ClassLoader classLoader = this.getDefaultClassLoader(testClass);
        String testClassName = JavaAssistUtils.javaClassNameToJvmResourceName((String)testClass.getName());
        URL testClassResource = classLoader.getResource(testClassName);
        if (testClassResource == null) {
            throw new IllegalArgumentException("testClassName not found." + testClassName);
        }
        this.logger.debug("url TestClass={}", (Object)testClassResource);
        String testClassPath = testClassResource.getPath();
        int classClassDirFind = testClassPath.indexOf("/" + testClassName);
        if (classClassDirFind == -1) {
            throw new IllegalArgumentException(testClassName + "not found.");
        }
        String testClassDir = testClassPath.substring(1, classClassDirFind);
        this.logger.debug("testClassDir:{}", (Object)testClassDir);
        return testClassDir;
    }

    private String getProjectPath(String modulePath) {
        if (modulePath == null) {
            throw new NullPointerException("modulePath must not be null");
        }
        int projectPathFound = modulePath.lastIndexOf(47);
        if (projectPathFound == -1) {
            throw new RuntimeException("projectPathFound not found");
        }
        String projectPath = modulePath.substring(0, projectPathFound);
        this.logger.debug("projectPath:{}", (Object)projectPath);
        return projectPath;
    }

    private String getModulePath(String targetPath) {
        int targetFound = targetPath.lastIndexOf("target");
        if (targetFound == -1) {
            throw new RuntimeException("target not found " + targetPath);
        }
        String modulePath = targetPath.substring(0, targetFound - 1);
        this.logger.debug("modulePath:{}", (Object)modulePath);
        return modulePath;
    }

    private String getPinpointAgentPath(String projectPath) {
        if (projectPath == null) {
            throw new NullPointerException("projectPath must not be null");
        }
        String pinpointAgentDir = projectPath + "/profiler/target/pinpoint-agent";
        this.logger.debug("pinpointAgentDir:{}", (Object)pinpointAgentDir);
        return pinpointAgentDir;
    }

    private String getTargetPath(String testClassDir) {
        if (testClassDir == null) {
            throw new NullPointerException("testClassDir must not be null");
        }
        String target = "target";
        int targetFound = testClassDir.lastIndexOf("target");
        if (targetFound == -1) {
            throw new NullPointerException("targetDir not found.");
        }
        String targetDir = testClassDir.substring(0, targetFound + "target".length());
        this.logger.debug("targetDir:{}", (Object)targetDir);
        return targetDir;
    }

    private ClassLoader getDefaultClassLoader(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return ProjectPathResolver.getClassLoader(classLoader);
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static class ProjectPath {
        private final String testClassPath;
        private final String targetPath;
        private final String modulePath;
        private final String projectPath;
        private final String pinpointAgentPath;

        public ProjectPath(String testClassPath, String targetPath, String modulePath, String projectPath, String pinpointAgentPath) {
            this.testClassPath = testClassPath;
            this.targetPath = targetPath;
            this.modulePath = modulePath;
            this.projectPath = projectPath;
            this.pinpointAgentPath = pinpointAgentPath;
        }

        public String getTestClassPath() {
            return this.testClassPath;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public String getModulePath() {
            return this.modulePath;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public String getPinpointAgentPath() {
            return this.pinpointAgentPath;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProjectPath{");
            sb.append("testClassPath='").append(this.testClassPath).append('\'');
            sb.append(", targetPath='").append(this.targetPath).append('\'');
            sb.append(", modulePath='").append(this.modulePath).append('\'');
            sb.append(", projectPath='").append(this.projectPath).append('\'');
            sb.append(", pinpointAgentPath='").append(this.pinpointAgentPath).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

