/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jboss;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.List;

public class JbossConfig {
    private final boolean hidePinpointHeader;
    private final Filter<String> excludeUrlFilter;
    private final boolean traceEjb;
    private final boolean enable;
    private final List<String> bootstrapMains;
    private final boolean conditionalTransformEnable;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final boolean traceRequestParam;
    private final Filter<String> excludeProfileMethodFilter;

    public JbossConfig(ProfilerConfig config) {
        this.enable = config.readBoolean("profiler.jboss.enable", true);
        this.traceEjb = config.readBoolean("profiler.jboss.traceEjb", false);
        this.bootstrapMains = config.readList("profiler.jboss.bootstrap.main");
        this.conditionalTransformEnable = config.readBoolean("profiler.jboss.conditional.transform", true);
        this.hidePinpointHeader = config.readBoolean("profiler.jboss.hidepinpointheader", true);
        this.traceRequestParam = config.readBoolean("profiler.jboss.tracerequestparam", true);
        String jbossExcludeURL = config.readString("profiler.jboss.excludeurl", "");
        this.excludeUrlFilter = !jbossExcludeURL.isEmpty() ? new ExcludePathFilter(jbossExcludeURL) : new SkipFilter();
        this.realIpHeader = config.readString("profiler.jboss.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.jboss.realipemptyvalue", null);
        String jbossExcludeProfileMethod = config.readString("profiler.jboss.excludemethod", "");
        this.excludeProfileMethodFilter = !jbossExcludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(jbossExcludeProfileMethod) : new SkipFilter();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public boolean isConditionalTransformEnable() {
        return this.conditionalTransformEnable;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public boolean isTraceEjb() {
        return this.traceEjb;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JbossConfig{");
        sb.append("hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", traceEjb=").append(this.traceEjb);
        sb.append(", enable=").append(this.enable);
        sb.append(", bootstrapMains=").append(this.bootstrapMains);
        sb.append(", conditionalTransformEnable=").append(this.conditionalTransformEnable);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append('}');
        return sb.toString();
    }
}

