/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resin;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.AsyncListenerInterceptorHelper;
import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletResponse;

public class ResinAsyncListener
implements AsyncListener {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final AsyncListenerInterceptorHelper asyncListenerInterceptorHelper;

    public ResinAsyncListener(TraceContext traceContext, AsyncContext asyncContext) {
        this.asyncListenerInterceptorHelper = new AsyncListenerInterceptorHelper(traceContext, asyncContext);
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        block5: {
            if (this.isDebug) {
                this.logger.debug("Complete asynchronous operation. event={}", (Object)asyncEvent);
            }
            if (asyncEvent == null) {
                if (this.isInfo) {
                    this.logger.info("Invalid event. event is null");
                }
                return;
            }
            try {
                int statusCode = this.getStatusCode(asyncEvent);
                this.asyncListenerInterceptorHelper.complete(asyncEvent.getThrowable(), statusCode);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block5;
                this.logger.info("Failed to async event handle. event={}", (Object)asyncEvent, (Object)t);
            }
        }
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        if (this.isDebug) {
            this.logger.debug("Timeout asynchronous operation. event={}", (Object)asyncEvent);
        }
        if (asyncEvent == null) {
            if (this.isDebug) {
                this.logger.debug("Invalid event. event is null");
            }
            return;
        }
        try {
            this.asyncListenerInterceptorHelper.timeout(asyncEvent.getThrowable());
        }
        catch (Throwable t) {
            this.logger.info("Failed to async event handle. event={}", (Object)asyncEvent, (Object)t);
        }
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        block5: {
            if (this.isDebug) {
                this.logger.debug("Error asynchronous operation. event={}", (Object)asyncEvent);
            }
            if (asyncEvent == null) {
                if (this.isInfo) {
                    this.logger.info("Invalid event. event is null");
                }
                return;
            }
            try {
                this.asyncListenerInterceptorHelper.error(asyncEvent.getThrowable());
            }
            catch (Throwable t) {
                if (!this.isInfo) break block5;
                this.logger.info("Failed to async event handle. event={}", (Object)asyncEvent, (Object)t);
            }
        }
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }

    private int getStatusCode(AsyncEvent asyncEvent) {
        try {
            if (asyncEvent.getSuppliedResponse() instanceof HttpServletResponse) {
                return ((HttpServletResponse)asyncEvent.getSuppliedResponse()).getStatus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

