/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import com.navercorp.pinpoint.plugin.vertx.interceptor.AsyncContextSpanEventEndPointInterceptor;
import io.vertx.core.http.impl.HttpServerResponseImpl;

public class HttpServerResponseImplInterceptor
extends AsyncContextSpanEventEndPointInterceptor {
    private final HttpStatusCodeRecorder httpStatusCodeRecorder;

    public HttpServerResponseImplInterceptor(MethodDescriptor methodDescriptor, TraceContext traceContext) {
        super(traceContext, methodDescriptor);
        this.httpStatusCodeRecorder = new HttpStatusCodeRecorder(traceContext.getProfilerConfig().getHttpStatusCodeErrors());
    }

    @Override
    public void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
    }

    @Override
    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(VertxConstants.VERTX_HTTP_SERVER_INTERNAL);
        recorder.recordException(throwable);
        if (target instanceof HttpServerResponseImpl) {
            Trace trace;
            HttpServerResponseImpl response = (HttpServerResponseImpl)target;
            AsyncContext asyncContext = this.getAsyncContext(target);
            if (asyncContext != null && (trace = asyncContext.currentAsyncTraceObject()) != null) {
                SpanRecorder spanRecorder = trace.getSpanRecorder();
                this.httpStatusCodeRecorder.record(spanRecorder, response.getStatusCode());
            }
        }
    }
}

