/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import com.navercorp.pinpoint.plugin.vertx.VertxHandleException;
import com.navercorp.pinpoint.plugin.vertx.interceptor.AsyncContextSpanEventEndPointInterceptor;

public class HandleExceptionInterceptor
extends AsyncContextSpanEventEndPointInterceptor {
    public HandleExceptionInterceptor(MethodDescriptor methodDescriptor, TraceContext traceContext) {
        super(traceContext, methodDescriptor);
    }

    @Override
    public void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
    }

    @Override
    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(VertxConstants.VERTX_INTERNAL);
        if (args != null && args.length >= 1 && args[0] instanceof Throwable) {
            Throwable handleException = (Throwable)args[0];
            if (throwable != null) {
                if (handleException != null) {
                    StringBuilder sb = new StringBuilder(256);
                    sb.append("handle=");
                    sb.append(StringUtils.abbreviate((String)handleException.getMessage(), (int)120));
                    sb.append(", catch=");
                    sb.append(StringUtils.abbreviate((String)throwable.getMessage(), (int)120));
                    recorder.recordException((Throwable)new VertxHandleException(sb.toString()));
                } else {
                    recorder.recordException(throwable);
                }
            } else if (handleException != null) {
                recorder.recordException(handleException);
            }
        }
    }
}

