/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.AsyncStateSupport;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;

public abstract class AsyncContextSpanEventEndPointInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected static final String ASYNC_TRACE_SCOPE = "##ASYNC_TRACE_SCOPE";
    protected final MethodDescriptor methodDescriptor;
    protected final TraceContext traceContext;

    public AsyncContextSpanEventEndPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = (TraceContext)Assert.requireNonNull((Object)traceContext, (String)"traceContext must not be null");
        this.methodDescriptor = (MethodDescriptor)Assert.requireNonNull((Object)methodDescriptor, (String)"methodDescriptor must not be null");
    }

    public void before(Object target, Object[] args) {
        block6: {
            AsyncContext asyncContext;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((asyncContext = this.getAsyncContext(target)) == null) {
                this.logger.debug("AsyncContext not found");
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            if (this.isDebug) {
                this.logger.debug("Asynchronous invocation. asyncTraceId={}, trace={}", (Object)asyncContext, (Object)trace);
            }
            this.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.doInBeforeTrace(recorder, asyncContext, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, AsyncContext var2, Object var3, Object[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        AsyncContext asyncContext;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((asyncContext = this.getAsyncContext(target)) == null) {
            this.logger.debug("Not found asynchronous invocation metadata");
            return;
        }
        if (this.isDebug) {
            this.logger.debug("Asynchronous invocation. asyncContext={}", (Object)asyncContext);
        }
        if ((trace = asyncContext.currentAsyncTraceObject()) == null) {
            return;
        }
        if (this.isDebug) {
            this.logger.debug("Asynchronous invocation. asyncTraceId={}, trace={}", (Object)asyncContext, (Object)trace);
        }
        if (!this.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (this.isAsyncTraceDestination(trace)) {
                if (this.isDebug) {
                    this.logger.debug("Arrived at async trace destination. asyncTraceId={}", (Object)asyncContext);
                }
                this.deleteAsyncTrace(trace);
            }
            this.finishAsyncState(asyncContext);
        }
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5);

    protected AsyncContext getAsyncContext(Object target) {
        return AsyncContextAccessorUtils.getAsyncContext((Object)target);
    }

    private Trace getAsyncTrace(AsyncContext asyncContext) {
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to continue async trace. 'result is null'");
            }
            return null;
        }
        if (this.isDebug) {
            this.logger.debug("getAsyncTrace() trace {}, asyncContext={}", (Object)trace, (Object)asyncContext);
        }
        return trace;
    }

    private void deleteAsyncTrace(Trace trace) {
        if (this.isDebug) {
            this.logger.debug("Delete async trace {}.", (Object)trace);
        }
        this.traceContext.removeTraceObject();
        trace.close();
    }

    private void entryAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            scope.tryEnter();
        }
    }

    private boolean leaveAsyncTraceScope(Trace trace) {
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isAsyncTraceDestination(Trace trace) {
        if (!trace.isAsync()) {
            return false;
        }
        TraceScope scope = trace.getScope(ASYNC_TRACE_SCOPE);
        return scope != null && !scope.isActive();
    }

    private void finishAsyncState(AsyncContext asyncContext) {
        if (asyncContext instanceof AsyncStateSupport) {
            AsyncStateSupport asyncStateSupport = (AsyncStateSupport)asyncContext;
            AsyncState asyncState = asyncStateSupport.getAsyncState();
            asyncState.finish();
            if (this.isDebug) {
                this.logger.debug("finished asyncState. asyncTraceId={}", (Object)asyncContext);
            }
        }
    }
}

