/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class VertxHttpClientConfig {
    private boolean param = true;
    private HttpDumpConfig httpDumpConfig;
    private boolean statusCode = true;

    public VertxHttpClientConfig(ProfilerConfig config) {
        this.param = config.readBoolean("profiler.vertx.http.client.param", true);
        boolean cookie = config.readBoolean("profiler.vertx.http.client.cookie", false);
        DumpType cookieDumpType = config.readDumpType("profiler.vertx.http.client.cookie.dumptype", DumpType.EXCEPTION);
        int cookieSamplingRate = config.readInt("profiler.vertx.http.client.cookie.sampling.rate", 1);
        int cookieDumpSize = config.readInt("profiler.vertx.http.client.cookie.dumpsize", 1024);
        this.httpDumpConfig = HttpDumpConfig.get((boolean)cookie, (DumpType)cookieDumpType, (int)cookieSamplingRate, (int)cookieDumpSize, (boolean)false, (DumpType)cookieDumpType, (int)1, (int)1024);
        this.statusCode = config.readBoolean("profiler.vertx.http.client.entity.statuscode", true);
    }

    public boolean isParam() {
        return this.param;
    }

    public HttpDumpConfig getHttpDumpConfig() {
        return this.httpDumpConfig;
    }

    public boolean isStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VertxHttpClientConfig{");
        sb.append("param=").append(this.param);
        sb.append(", httpDumpConfig=").append(this.httpDumpConfig);
        sb.append(", statusCode=").append(this.statusCode);
        sb.append('}');
        return sb.toString();
    }
}

