/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.activemq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientConstants;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQTextMessage;

public class ActiveMQMessageConsumerReceiveInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final boolean traceActiveMQTextMessage;

    public ActiveMQMessageConsumerReceiveInterceptor(TraceContext traceContext, MethodDescriptor descriptor, boolean traceActiveMQTextMessage) {
        super(traceContext, descriptor);
        this.traceActiveMQTextMessage = traceActiveMQTextMessage;
    }

    protected void logBeforeInterceptor(Object target, Object[] args) {
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        if (this.isDebug) {
            super.logBeforeInterceptor(target, args);
        }
    }

    protected void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            super.logAfterInterceptor(target, args, result, throwable);
        }
        recorder.recordServiceType(ActiveMQClientConstants.ACTIVEMQ_CLIENT_INTERNAL);
        recorder.recordApi(this.getMethodDescriptor());
        if (throwable != null) {
            recorder.recordException(throwable);
        } else if (this.traceActiveMQTextMessage && result != null) {
            String message = this.getMessage(result);
            recorder.recordAttribute(ActiveMQClientConstants.ACTIVEMQ_MESSAGE, message);
        }
    }

    private String getMessage(Object result) {
        String simpleClassName = result.getClass().getSimpleName();
        try {
            if (result instanceof ActiveMQTextMessage) {
                String text = ((ActiveMQTextMessage)result).getText();
                StringBuilder sb = new StringBuilder(simpleClassName);
                sb.append('{').append(text).append('}');
                return sb.toString();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return simpleClassName;
    }
}

