/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertow;

import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterExtractor;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;

public class HttpServerExchangeParameterExtractor
implements ParameterExtractor<HttpServerExchange> {
    private int eachLimit;
    private int totalLimit;

    public HttpServerExchangeParameterExtractor(int eachLimit, int totalLimit) {
        this.eachLimit = eachLimit;
        this.totalLimit = totalLimit;
    }

    public String extractParameter(HttpServerExchange request) {
        Map parameterMap = request.getQueryParameters();
        StringBuilder params = new StringBuilder(64);
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (params.length() != 0) {
                params.append('&');
            }
            if (params.length() > this.totalLimit) {
                params.append("...");
                return params.toString();
            }
            String key = (String)entry.getKey();
            if (!StringUtils.hasLength((String)key)) continue;
            params.append(StringUtils.abbreviate((String)key, (int)this.eachLimit));
            params.append('=');
            Deque values = (Deque)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            for (String value : values) {
                if (value == null) continue;
                params.append(StringUtils.abbreviate((String)StringUtils.toString((Object)value), (int)this.eachLimit));
            }
        }
        return params.toString();
    }
}

