/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.util.BodyFactory;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadCount;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadCountRes;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TCommandEcho;
import com.navercorp.pinpoint.thrift.dto.command.TCommandThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCommandThreadDumpResponse;
import com.navercorp.pinpoint.thrift.dto.command.TCommandTransfer;
import com.navercorp.pinpoint.thrift.dto.command.TCommandTransferResponse;
import java.util.EnumSet;
import java.util.Set;
import org.apache.thrift.TBase;

public enum TCommandType {
    RESULT(320, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TResult();
        }
    }),
    TRANSFER(700, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCommandTransfer();
        }
    }),
    TRANSFER_RESPONSE(701, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCommandTransferResponse();
        }
    }),
    ECHO(710, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCommandEcho();
        }
    }),
    THREAD_DUMP(720, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCommandThreadDump();
        }
    }),
    THREAD_DUMP_RESPONSE(721, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCommandThreadDumpResponse();
        }
    }),
    ACTIVE_THREAD_COUNT(730, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCmdActiveThreadCount();
        }
    }),
    ACTIVE_THREAD_COUNT_RESPONSE(731, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCmdActiveThreadCountRes();
        }
    }),
    ACTIVE_THREAD_DUMP(740, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCmdActiveThreadDump();
        }
    }),
    ACTIVE_THREAD_DUMP_RESPONSE(741, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCmdActiveThreadDumpRes();
        }
    }),
    ACTIVE_THREAD_LIGHT_DUMP(750, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCmdActiveThreadLightDump();
        }
    }),
    ACTIVE_THREAD_LIGHT_DUMP_RESPONSE(751, new BodyFactory<TBase<?, ?>>(){

        @Override
        public TBase<?, ?> getObject() {
            return new TCmdActiveThreadLightDumpRes();
        }
    });

    private final short code;
    private final Class<? extends TBase> clazz;
    private final BodyFactory<TBase<?, ?>> bodyFactory;
    private static final Set<TCommandType> TCOMMAND_TYPES;

    private TCommandType(short code, BodyFactory<TBase<?, ?>> bodyFactory) {
        this.code = code;
        this.bodyFactory = bodyFactory;
        this.clazz = bodyFactory.getObject().getClass();
    }

    public short getCode() {
        return this.code;
    }

    public Class<? extends TBase> getClazz() {
        return this.clazz;
    }

    public BodyFactory<TBase<?, ?>> getBodyFactory() {
        return this.bodyFactory;
    }

    @Deprecated
    public static TCommandType getType(Class<? extends TBase> clazz) {
        for (TCommandType commandType : TCOMMAND_TYPES) {
            if (commandType.getClazz() != clazz) continue;
            return commandType;
        }
        return null;
    }

    public static TCommandType getType(short code) {
        for (TCommandType commandType : TCOMMAND_TYPES) {
            if (commandType.getCode() != code) continue;
            return commandType;
        }
        return null;
    }

    static {
        TCOMMAND_TYPES = EnumSet.allOf(TCommandType.class);
    }
}

