/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operand;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.ClassUtils;

@InterfaceStability.Unstable
public class InterfaceInternalNameMatcherOperand
extends AbstractMatcherOperand {
    private final String interfaceInternalName;
    private final boolean considerHierarchy;
    private final boolean javaPackage;

    public InterfaceInternalNameMatcherOperand(String interfaceName, boolean considerHierarchy) {
        Assert.requireNonNull(interfaceName, "interfaceName must not be null");
        this.interfaceInternalName = ClassUtils.toInternalName(interfaceName);
        this.considerHierarchy = considerHierarchy;
        this.javaPackage = this.interfaceInternalName.startsWith("java/");
    }

    public String getInterfaceInternalName() {
        return this.interfaceInternalName;
    }

    public boolean isConsiderHierarchy() {
        return this.considerHierarchy;
    }

    public boolean match(String interfaceInternalName) {
        if (interfaceInternalName == null) {
            return false;
        }
        return this.interfaceInternalName.equals(interfaceInternalName);
    }

    public boolean isJavaPackage() {
        return this.javaPackage;
    }

    @Override
    public int getExecutionCost() {
        return this.considerHierarchy ? 5 : 2;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("interfaceInternalName=").append(this.interfaceInternalName);
        sb.append(", considerHierarchy=").append(this.considerHierarchy);
        sb.append('}');
        return sb.toString();
    }
}

