/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.classloader;

import com.navercorp.pinpoint.bootstrap.classloader.BootLoader;
import com.navercorp.pinpoint.bootstrap.classloader.BootLoaderFactory;
import com.navercorp.pinpoint.bootstrap.classloader.LibClass;
import com.navercorp.pinpoint.bootstrap.classloader.MergedEnumeration2;
import com.navercorp.pinpoint.bootstrap.classloader.ProfilerLibClass;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;

public class Java6ClassLoader
extends URLClassLoader {
    private final BootLoader bootLoader = BootLoaderFactory.newBootLoader();
    private final ClassLoader parent;
    private final LibClass libClass;
    private final String name;

    public Java6ClassLoader(String name, URL[] urls, ClassLoader parent, List<String> libClass) {
        super(urls, parent);
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.name = name;
        if (libClass == null) {
            throw new NullPointerException("libClass must not be null");
        }
        this.parent = parent;
        this.libClass = new ProfilerLibClass(libClass);
    }

    private Object getClassLoadingLock0(String name) {
        return this;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.parent != null ? this.parent.getResource(name) : this.bootLoader.findResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> currentResource = this.findResources(name);
        Enumeration<URL> parentResource = this.parent != null ? this.parent.getResources(name) : this.bootLoader.findResources(name);
        return new MergedEnumeration2<URL>(currentResource, parentResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock0(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                if (this.onLoadClass(name)) {
                    clazz = this.findClass(name);
                } else {
                    try {
                        clazz = this.parent != null ? this.parent.loadClass(name) : this.bootLoader.findBootstrapClassOrNull(this, name);
                    }
                    catch (ClassNotFoundException ignore) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        clazz = this.findClass(name);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private boolean onLoadClass(String name) {
        return this.libClass.onLoadClass(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Java6ClassLoader{name='" + this.name + '\'' + "} " + super.toString();
    }
}

