/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat.interceptor;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.loader.WebappLoader;

public class WebappLoaderStartInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TraceContext traceContext;

    public WebappLoaderStartInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (target instanceof WebappLoader) {
            WebappLoader webappLoader = (WebappLoader)target;
            try {
                String contextKey = this.extractContextKey(webappLoader);
                List<String> loadedJarNames = this.extractLibJars(webappLoader);
                this.dispatchLibJars(contextKey, loadedJarNames);
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            this.logger.warn("Webapp loader is not an instance of org.apache.catalina.loader.WebappLoader. Found [{}]", (Object)target.getClass().toString());
        }
    }

    private String extractContextKey(WebappLoader webappLoader) {
        String defaultContextName = "";
        try {
            Container container = this.extractContext(webappLoader);
            if (container instanceof Context) {
                Context context = (Context)container;
                String contextName = context.getName();
                Host host = (Host)container.getParent();
                Engine engine = (Engine)host.getParent();
                StringBuilder sb = new StringBuilder();
                sb.append(engine.getName()).append("/").append(host.getName());
                if (!contextName.startsWith("/")) {
                    sb.append('/');
                }
                sb.append(contextName);
                return sb.toString();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error extracting context name.", (Throwable)e);
        }
        return "";
    }

    private Container extractContext(WebappLoader webappLoader) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m;
        try {
            m = webappLoader.getClass().getDeclaredMethod("getContainer", new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            try {
                m = webappLoader.getClass().getDeclaredMethod("getContext", new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                this.logger.warn("Webapp loader does not have access to its container.");
                return null;
            }
        }
        Object container = m.invoke((Object)webappLoader, new Object[0]);
        if (container instanceof Container) {
            return (Container)container;
        }
        return null;
    }

    private List<String> extractLibJars(WebappLoader webappLoader) {
        ClassLoader classLoader = webappLoader.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader webappClassLoader = (URLClassLoader)classLoader;
            URL[] urls = webappClassLoader.getURLs();
            return this.extractLibJarNamesFromURLs(urls);
        }
        this.logger.warn("Webapp class loader is not an instance of URLClassLoader. Found [{}]", (Object)classLoader.getClass().toString());
        return Collections.emptyList();
    }

    private List<String> extractLibJarNamesFromURLs(URL[] urls) {
        if (urls == null) {
            return Collections.emptyList();
        }
        ArrayList<String> libJarNames = new ArrayList<String>(urls.length);
        for (URL url : urls) {
            try {
                URI uri = url.toURI();
                String libJarName = this.extractLibJarName(uri);
                if (libJarName.length() <= 0) continue;
                libJarNames.add(libJarName);
            }
            catch (URISyntaxException e) {
                this.logger.warn("Invalid library url found : [{}]", (Object)url, (Object)e);
            }
            catch (Exception e) {
                this.logger.warn("Error extracting library name", (Throwable)e);
            }
        }
        return libJarNames;
    }

    private String extractLibJarName(URI uri) {
        String jarName = uri.toString();
        if (jarName == null) {
            return "";
        }
        int lastIndexOfSeparator = jarName.lastIndexOf("/");
        if (lastIndexOfSeparator < 0) {
            return jarName;
        }
        return jarName.substring(lastIndexOfSeparator + 1);
    }

    private void dispatchLibJars(String contextKey, List<String> libJars) {
        ServerMetaDataHolder holder = this.traceContext.getServerMetaDataHolder();
        holder.addServiceInfo(contextKey, libJars);
        holder.notifyListeners();
    }
}

