/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AsyncContextSpanEventSimpleAroundInterceptor;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import com.navercorp.pinpoint.plugin.vertx.VertxHttpClientConfig;
import io.vertx.core.http.impl.HttpClientResponseImpl;

public class HttpClientRequestImplConnectedInterceptor
extends AsyncContextSpanEventSimpleAroundInterceptor {
    private boolean statusCode;

    public HttpClientRequestImplConnectedInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
        VertxHttpClientConfig config = new VertxHttpClientConfig(traceContext.getProfilerConfig());
        this.statusCode = config.isStatusCode();
    }

    public void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
        if (!this.validate(args)) {
            return;
        }
        HttpClientResponseImpl response = (HttpClientResponseImpl)args[0];
        if (this.statusCode) {
            recorder.recordAttribute(AnnotationKey.HTTP_STATUS_CODE, response.statusCode());
        }
        ((AsyncContextAccessor)response)._$PINPOINT$_setAsyncContext(asyncContext);
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 1 || !(args[0] instanceof HttpClientResponseImpl)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. args={}.", args);
            }
            return false;
        }
        if (!(args[0] instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. Need metadata accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(VertxConstants.VERTX_HTTP_CLIENT_INTERNAL);
        recorder.recordException(throwable);
    }
}

