/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.json_lib;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.json_lib.JsonLibConfig;
import com.navercorp.pinpoint.plugin.json_lib.JsonLibConstants;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;

public class JsonLibPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String BASIC_INTERCEPTOR = BasicMethodInterceptor.class.getName();
    private static final String PARSING_INTERCEPTOR = "com.navercorp.pinpoint.plugin.json_lib.interceptor.ParsingInterceptor";
    private static final String TO_STRING_INTERCEPTOR = "com.navercorp.pinpoint.plugin.json_lib.interceptor.ToStringInterceptor";
    private static final String JSON_LIB_SCOPE = "json-lib";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JsonLibConfig config = new JsonLibConfig(context.getConfig());
        this.logger.debug("[JsonLib] Initialized config={}", (Object)config);
        if (config.isProfile()) {
            this.addJSONSerializerInterceptor("net.sf.json.JSONSerializer");
            this.addJSONObjectInterceptor("net.sf.json.JSONObject");
            this.addJSONArrayInterceptor("net.sf.json.JSONArray");
        }
    }

    private void addJSONSerializerInterceptor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJSON"}))) {
                    JsonLibPlugin.this.addInterceptor(method, JsonLibPlugin.PARSING_INTERCEPTOR, new Object[0]);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJava"}))) {
                    JsonLibPlugin.this.addInterceptor(method, BASIC_INTERCEPTOR, new Object[]{JsonLibConstants.SERVICE_TYPE});
                }
                return target.toBytecode();
            }
        });
    }

    private void addJSONObjectInterceptor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"fromObject"}))) {
                    JsonLibPlugin.this.addInterceptor(method, JsonLibPlugin.PARSING_INTERCEPTOR, new Object[0]);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toBean"}))) {
                    JsonLibPlugin.this.addInterceptor(method, BASIC_INTERCEPTOR, new Object[]{JsonLibConstants.SERVICE_TYPE});
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toString"}))) {
                    JsonLibPlugin.this.addInterceptor(method, JsonLibPlugin.TO_STRING_INTERCEPTOR, new Object[0]);
                }
                return target.toBytecode();
            }
        });
    }

    private void addJSONArrayInterceptor(String clazzName) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"fromObject"}))) {
                    JsonLibPlugin.this.addInterceptor(method, JsonLibPlugin.PARSING_INTERCEPTOR, new Object[0]);
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toArray"}))) {
                    JsonLibPlugin.this.addInterceptor(method, BASIC_INTERCEPTOR, new Object[]{JsonLibConstants.SERVICE_TYPE});
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toList"}))) {
                    JsonLibPlugin.this.addInterceptor(method, BASIC_INTERCEPTOR, new Object[]{JsonLibConstants.SERVICE_TYPE});
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toCollection"}))) {
                    JsonLibPlugin.this.addInterceptor(method, BASIC_INTERCEPTOR, new Object[]{JsonLibConstants.SERVICE_TYPE});
                }
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toString"}))) {
                    JsonLibPlugin.this.addInterceptor(method, JsonLibPlugin.TO_STRING_INTERCEPTOR, new Object[0]);
                }
                return target.toBytecode();
            }
        });
    }

    private boolean addInterceptor(InstrumentMethod method, String interceptorClassName, Object ... constructorArgs) {
        block3: {
            if (method != null && this.isPublicMethod(method)) {
                try {
                    method.addScopedInterceptor(interceptorClassName, constructorArgs, JSON_LIB_SCOPE);
                    return true;
                }
                catch (InstrumentException e) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Unsupported method " + method, (Throwable)e);
                }
            }
        }
        return false;
    }

    private boolean isPublicMethod(InstrumentMethod method) {
        int modifier = method.getModifiers();
        return Modifier.isPublic(modifier);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

