/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.websphere.interceptor;

import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.webcontainer.channel.WCCResponseImpl;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListenerInterceptorHelper;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.websphere.ParameterRecorderFactory;
import com.navercorp.pinpoint.plugin.websphere.StatusCodeAccessor;
import com.navercorp.pinpoint.plugin.websphere.WebsphereConfiguration;
import com.navercorp.pinpoint.plugin.websphere.WebsphereConstants;
import com.navercorp.pinpoint.plugin.websphere.common.servlet.util.ArgumentValidator;
import com.navercorp.pinpoint.plugin.websphere.common.servlet.util.ServletArgumentValidator;
import com.navercorp.pinpoint.plugin.websphere.interceptor.IRequestAdaptor;

public class WebContainerHandleRequestInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor methodDescriptor;
    private final ArgumentValidator argumentValidator;
    private final ServletRequestListenerInterceptorHelper<IRequest> servletRequestListenerInterceptorHelper;

    public WebContainerHandleRequestInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.methodDescriptor = descriptor;
        this.argumentValidator = new ServletArgumentValidator(this.logger, 0, IRequest.class, 1, IResponse.class);
        WebsphereConfiguration config = new WebsphereConfiguration(traceContext.getProfilerConfig());
        IRequestAdaptor requestAdaptor = new IRequestAdaptor();
        requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        ParameterRecorder<IRequest> parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.servletRequestListenerInterceptorHelper = new ServletRequestListenerInterceptorHelper(WebsphereConstants.WEBSPHERE, traceContext, (RequestAdaptor)requestAdaptor, config.getExcludeUrlFilter(), parameterRecorder);
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!this.argumentValidator.validate(args)) {
            return;
        }
        try {
            IRequest request = (IRequest)args[0];
            this.servletRequestListenerInterceptorHelper.initialized((Object)request, WebsphereConstants.WEBSPHERE_METHOD, this.methodDescriptor);
        }
        catch (Throwable t) {
            this.logger.info("Failed to servlet request event handle.", t);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.argumentValidator.validate(args)) {
            return;
        }
        try {
            IRequest request = (IRequest)args[0];
            IResponse response = (IResponse)args[1];
            int statusCode = this.getStatusCode(response);
            this.servletRequestListenerInterceptorHelper.destroyed((Object)request, throwable, statusCode);
        }
        catch (Throwable t) {
            this.logger.info("Failed to servlet request event handle.", t);
        }
    }

    private int getStatusCode(IResponse response) {
        try {
            if (response instanceof StatusCodeAccessor) {
                StatusCodeAccessor accessor = (StatusCodeAccessor)response;
                return accessor._$PINPOINT$_getStatusCode();
            }
            if (response instanceof WCCResponseImpl) {
                WCCResponseImpl r = (WCCResponseImpl)response;
                return r.getHttpResponse().getStatusCodeAsInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

