/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerLoader;
import com.navercorp.pinpoint.profiler.plugin.DefaultProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.plugin.GuardProfilerPluginContext;
import com.navercorp.pinpoint.profiler.plugin.PluginInstrumentContext;
import com.navercorp.pinpoint.profiler.plugin.PluginSetup;
import com.navercorp.pinpoint.profiler.plugin.SetupResult;

public class MockPluginSetup
implements PluginSetup {
    private final ProfilerConfig profilerConfig;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;

    @Inject
    public MockPluginSetup(ProfilerConfig profilerConfig, InstrumentEngine instrumentEngine, DynamicTransformTrigger dynamicTransformTrigger) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (instrumentEngine == null) {
            throw new NullPointerException("instrumentEngine must not be null");
        }
        if (dynamicTransformTrigger == null) {
            throw new NullPointerException("dynamicTransformTrigger must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.instrumentEngine = instrumentEngine;
        this.dynamicTransformTrigger = dynamicTransformTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetupResult setupPlugin(ProfilerPlugin plugin, ClassInjector classInjector) {
        DefaultProfilerPluginSetupContext pluginSetupContext = new DefaultProfilerPluginSetupContext(this.profilerConfig);
        GuardProfilerPluginContext guardPluginSetupContext = new GuardProfilerPluginContext((ProfilerPluginSetupContext)pluginSetupContext);
        ClassFileTransformerLoader classFileTransformerLoader = new ClassFileTransformerLoader(this.profilerConfig, this.dynamicTransformTrigger);
        PluginInstrumentContext instrumentContext = new PluginInstrumentContext(this.profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger, classInjector, classFileTransformerLoader);
        try {
            this.preparePlugin(plugin, (InstrumentContext)instrumentContext);
            plugin.setup((ProfilerPluginSetupContext)guardPluginSetupContext);
        }
        finally {
            guardPluginSetupContext.close();
        }
        SetupResult setup = new SetupResult(pluginSetupContext, classFileTransformerLoader);
        return setup;
    }

    private void preparePlugin(ProfilerPlugin plugin, InstrumentContext context) {
        if (plugin instanceof TransformTemplateAware) {
            TransformTemplate transformTemplate = new TransformTemplate(context);
            ((TransformTemplateAware)plugin).setTransformTemplate(transformTemplate);
        } else if (plugin instanceof MatchableTransformTemplateAware) {
            MatchableTransformTemplate transformTemplate = new MatchableTransformTemplate(context);
            ((MatchableTransformTemplateAware)plugin).setTransformTemplate(transformTemplate);
        }
    }
}

