/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.common.plugin.Plugin;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import com.navercorp.pinpoint.profiler.plugin.SetupResult;
import com.navercorp.pinpoint.test.MockPluginSetup;
import com.navercorp.pinpoint.test.TestProfilerPluginClassLoader;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MockPluginContextLoadResult
implements PluginContextLoadResult {
    private final ProfilerConfig profilerConfig;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final PluginLoader pluginLoader;
    private List<SetupResult> lazy;

    public MockPluginContextLoadResult(ProfilerConfig profilerConfig, InstrumentEngine instrumentEngine, DynamicTransformTrigger dynamicTransformTrigger, PluginLoader pluginLoader) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.instrumentEngine = (InstrumentEngine)Assert.requireNonNull((Object)instrumentEngine, (String)"instrumentEngine must not be null");
        this.dynamicTransformTrigger = (DynamicTransformTrigger)Assert.requireNonNull((Object)dynamicTransformTrigger, (String)"dynamicTransformTrigger must not be null");
        this.pluginLoader = (PluginLoader)Assert.requireNonNull((Object)pluginLoader, (String)"pluginLoader must not be null");
    }

    private List<SetupResult> getProfilerPluginContextList() {
        if (this.lazy == null) {
            this.lazy = this.load();
        }
        return this.lazy;
    }

    private List<SetupResult> load() {
        List plugins = this.pluginLoader.load(ProfilerPlugin.class);
        ArrayList<SetupResult> pluginContexts = new ArrayList<SetupResult>();
        TestProfilerPluginClassLoader classInjector = new TestProfilerPluginClassLoader();
        MockPluginSetup pluginSetup = new MockPluginSetup(this.profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger);
        for (Plugin plugin : plugins) {
            for (ProfilerPlugin profilerPlugin : plugin.getInstanceList()) {
                SetupResult context = pluginSetup.setupPlugin(profilerPlugin, classInjector);
                pluginContexts.add(context);
            }
        }
        return pluginContexts;
    }

    public List<ClassFileTransformer> getClassFileTransformer() {
        ArrayList<ClassFileTransformer> classFileTransformerList = new ArrayList<ClassFileTransformer>();
        for (SetupResult pluginContext : this.getProfilerPluginContextList()) {
            List classFileTransformer = pluginContext.getClassTransformerList();
            classFileTransformerList.addAll(classFileTransformer);
        }
        return classFileTransformerList;
    }

    public List<ApplicationTypeDetector> getApplicationTypeDetectorList() {
        return Collections.emptyList();
    }

    public List<JdbcUrlParserV2> getJdbcUrlParserList() {
        return Collections.emptyList();
    }
}

