/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.google.inject.Module;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.DefaultAgentOption;
import com.navercorp.pinpoint.bootstrap.config.DefaultProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.test.DummyInstrumentation;
import com.navercorp.pinpoint.test.InterceptorRegistryModule;
import com.navercorp.pinpoint.test.MockApplicationContextModule;
import com.navercorp.pinpoint.test.OverrideModuleFactory;
import com.navercorp.pinpoint.test.TestInterceptorRegistryBinder;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.Collections;

public class MockApplicationContextFactory {
    public DefaultApplicationContext build(String configPath) {
        ProfilerConfig profilerConfig = this.readProfilerConfig(configPath, this.getClass().getClassLoader());
        return this.build(profilerConfig);
    }

    private ProfilerConfig readProfilerConfig(String configPath, ClassLoader classLoader) {
        String path = this.getFilePath(classLoader, configPath);
        ProfilerConfig profilerConfig = this.loadProfilerConfig(path);
        ((DefaultProfilerConfig)profilerConfig).setApplicationServerType(ServiceType.TEST_STAND_ALONE.getName());
        return profilerConfig;
    }

    private ProfilerConfig loadProfilerConfig(String path) {
        try {
            return DefaultProfilerConfig.load((String)path);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private String getFilePath(ClassLoader classLoader, String configPath) {
        URL resource = classLoader.getResource(configPath);
        if (resource == null) {
            throw new RuntimeException("pinpoint.config not found. configPath:" + configPath);
        }
        return resource.getPath();
    }

    public DefaultApplicationContext build(ProfilerConfig config) {
        DefaultApplicationContext context = this.build(config, this.newModuleFactory());
        return context;
    }

    public DefaultApplicationContext build(ProfilerConfig config, ModuleFactory moduleFactory) {
        DummyInstrumentation instrumentation = new DummyInstrumentation();
        String mockAgent = "mockAgent";
        String mockApplicationName = "mockApplicationName";
        DefaultAgentOption agentOption = new DefaultAgentOption((Instrumentation)instrumentation, mockAgent, mockApplicationName, false, config, Collections.emptyList(), null);
        return new DefaultApplicationContext((AgentOption)agentOption, moduleFactory);
    }

    private ModuleFactory newModuleFactory() {
        MockApplicationContextModule pluginModule = new MockApplicationContextModule();
        TestInterceptorRegistryBinder binder = new TestInterceptorRegistryBinder();
        Module interceptorRegistryModule = InterceptorRegistryModule.wrap(binder);
        OverrideModuleFactory moduleFactory = new OverrideModuleFactory(new Module[]{pluginModule, interceptorRegistryModule});
        return moduleFactory;
    }
}

