/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.redis.jedis.EndPointAccessor;
import com.navercorp.pinpoint.plugin.redis.jedis.EndPointUtils;
import java.net.URI;
import redis.clients.jedis.JedisShardInfo;

public class SetEndPointInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public SetEndPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
    }

    public void before(Object target, Object[] args) {
        block4: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                if (!this.validate(target, args)) {
                    return;
                }
                String endPoint = this.getEndPoint(args);
                ((EndPointAccessor)target)._$PINPOINT$_setEndPoint(endPoint);
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
            }
        }
    }

    private String getEndPoint(Object[] args) {
        Object argZero = args[0];
        if (argZero instanceof String) {
            return EndPointUtils.getEndPoint(args);
        }
        if (argZero instanceof URI) {
            URI uri = (URI)argZero;
            return HostAndPort.toHostAndPortString((String)uri.getHost(), (int)uri.getPort());
        }
        if (argZero instanceof JedisShardInfo) {
            JedisShardInfo info = (JedisShardInfo)argZero;
            return HostAndPort.toHostAndPortString((String)info.getHost(), (int)info.getPort());
        }
        return "Unknown";
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null || args.length == 0 || args[0] == null) {
            if (this.isDebug) {
                this.logger.debug("Invalid arguments. Null or not found args({}).", args);
            }
            return false;
        }
        if (!(target instanceof EndPointAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)EndPointAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
    }
}

