/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.redis.jedis.CommandContext;

public class ProtocolSendCommandAndReadMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor methodDescriptor;
    private InterceptorScope interceptorScope;

    public ProtocolSendCommandAndReadMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            Object attachment = this.getAttachment(invocation);
            if (attachment instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)attachment;
                if (this.methodDescriptor.getMethodName().equals("sendCommand")) {
                    commandContext.setWriteBeginTime(System.currentTimeMillis());
                } else {
                    commandContext.setReadBeginTime(System.currentTimeMillis());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Set command context {}", (Object)commandContext);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            Object attachment = this.getAttachment(invocation);
            if (attachment instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)attachment;
                if (this.methodDescriptor.getMethodName().equals("sendCommand")) {
                    commandContext.setWriteEndTime(System.currentTimeMillis());
                    commandContext.setWriteFail(throwable != null);
                } else {
                    commandContext.setReadEndTime(System.currentTimeMillis());
                    commandContext.setReadFail(throwable != null);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Set command context {}", (Object)commandContext);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to AFTER process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }
}

