/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.gson;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyFactory;
import com.navercorp.pinpoint.common.trace.AnnotationKeyProperty;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeFactory;
import com.navercorp.pinpoint.common.trace.ServiceTypeProperty;
import com.navercorp.pinpoint.plugin.gson.GsonConfig;
import java.security.ProtectionDomain;

public class GsonPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    public static final ServiceType GSON_SERVICE_TYPE = ServiceTypeFactory.of((int)5010, (String)"GSON", (ServiceTypeProperty[])new ServiceTypeProperty[0]);
    public static final AnnotationKey GSON_ANNOTATION_KEY_JSON_LENGTH = AnnotationKeyFactory.of((int)9000, (String)"gson.json.length", (AnnotationKeyProperty[])new AnnotationKeyProperty[0]);
    private static final String GSON_SCOPE = "GSON_SCOPE";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        GsonConfig config = new GsonConfig(context.getConfig());
        this.logger.debug("[Gson] Initialized config={}", (Object)config);
        if (config.isProfile()) {
            this.transformTemplate.transform("com.google.gson.Gson", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"fromJson"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.gson.interceptor.FromJsonInterceptor", GsonPlugin.GSON_SCOPE);
                    }
                    for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"toJson"}))) {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.gson.interceptor.ToJsonInterceptor", GsonPlugin.GSON_SCOPE);
                    }
                    return target.toBytecode();
                }
            });
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

