/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.server.nonblocking;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.SocketFieldAccessor;
import com.navercorp.pinpoint.plugin.thrift.field.getter.TNonblockingTransportFieldGetter;
import java.net.Socket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;

public abstract class FrameBufferTransportInjectInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.validate0(target, args, result)) {
            Socket rootSocket;
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if ((rootSocket = this.getRootSocket(target)) != null) {
                TTransport injectionTarget = this.getInjectionTarget(target, args, result);
                this.injectSocket(injectionTarget, rootSocket);
            }
        }
    }

    private boolean validate0(Object target, Object[] args, Object result) {
        if (!(target instanceof SocketFieldAccessor)) {
            if (!this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)SocketFieldAccessor.class.getName());
            }
            return false;
        }
        return this.validate(target, args, result);
    }

    protected boolean validate(Object target, Object[] args, Object result) {
        return true;
    }

    protected abstract TTransport getInjectionTarget(Object var1, Object[] var2, Object var3);

    protected final Socket getRootSocket(Object target) {
        TNonblockingTransport inTrans;
        if (target instanceof TNonblockingTransportFieldGetter && (inTrans = ((TNonblockingTransportFieldGetter)target)._$PINPOINT$_getTNonblockingTransport()) != null) {
            if (inTrans instanceof SocketFieldAccessor) {
                return ((SocketFieldAccessor)inTrans)._$PINPOINT$_getSocket();
            }
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)SocketFieldAccessor.class.getName());
            }
        }
        return null;
    }

    protected final void injectSocket(TTransport inTrans, Socket rootSocket) {
        if (!(inTrans instanceof SocketFieldAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)SocketFieldAccessor.class.getName());
            }
            return;
        }
        ((SocketFieldAccessor)inTrans)._$PINPOINT$_setSocket(rootSocket);
    }
}

