/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.openwhisk.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConfig;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConstants;
import com.navercorp.pinpoint.plugin.openwhisk.descriptor.LogMarkerMethodDescriptor;
import scala.runtime.AbstractFunction0;
import whisk.common.LogMarkerToken;

public class TransactionIdMarkInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isLoggingMessage;

    public TransactionIdMarkInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        OpenwhiskConfig config = new OpenwhiskConfig(traceContext.getProfilerConfig());
        this.isLoggingMessage = config.isLoggingMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(Object target, Object[] args) {
        AsyncContext asyncContext;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((asyncContext = AsyncContextAccessorUtils.getAsyncContext((Object)args[0])) == null) {
            this.logger.debug("Not found asynchronous invocation metadata {}", (Object)((LogMarkerToken)args[2]));
            return;
        }
        Trace trace = asyncContext.continueAsyncTraceObject();
        if (trace == null) {
            this.logger.debug("trace object null");
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(OpenwhiskConstants.OPENWHISK_INTERNAL);
        try {
            LogMarkerToken logMarkerToken = (LogMarkerToken)args[2];
            String message = ((AbstractFunction0)args[3]).apply().toString();
            recorder.recordApi((MethodDescriptor)new LogMarkerMethodDescriptor(logMarkerToken));
            if (this.isLoggingMessage && message.length() > 0) {
                recorder.recordAttribute(OpenwhiskConstants.MARKER_MESSAGE, message);
            }
        }
        finally {
            trace.traceBlockEnd();
            trace.close();
            asyncContext.close();
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
    }
}

