/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ContinueTraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.DisableTraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.NewTraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeaderReader;
import com.navercorp.pinpoint.bootstrap.sampler.SamplingFlagUtils;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.util.Assert;

public class DefaultTraceHeaderReader<T>
implements TraceHeaderReader<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final RequestAdaptor<T> requestAdaptor;

    public DefaultTraceHeaderReader(RequestAdaptor<T> requestAdaptor) {
        this.requestAdaptor = (RequestAdaptor)Assert.requireNonNull(requestAdaptor, (String)"requestAdaptor must not be null");
    }

    @Override
    public TraceHeader read(T request) {
        boolean sampling;
        Assert.requireNonNull(request, (String)"request must not be null");
        String samplingFlag = this.requestAdaptor.getHeader(request, Header.HTTP_SAMPLED.toString());
        if (this.isDebug) {
            this.logger.debug("SamplingFlag={}", (Object)samplingFlag);
        }
        if (!(sampling = this.samplingEnable(request))) {
            return DisableTraceHeader.INSTANCE;
        }
        String transactionId = this.requestAdaptor.getHeader(request, Header.HTTP_TRACE_ID.toString());
        if (transactionId == null) {
            return NewTraceHeader.INSTANCE;
        }
        String parentSpanIdStr = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_SPAN_ID.toString());
        if (parentSpanIdStr == null) {
            return NewTraceHeader.INSTANCE;
        }
        long parentSpanId = NumberUtils.parseLong(parentSpanIdStr, -1L);
        String spanIdStr = this.requestAdaptor.getHeader(request, Header.HTTP_SPAN_ID.toString());
        if (spanIdStr == null) {
            return NewTraceHeader.INSTANCE;
        }
        long spanId = NumberUtils.parseLong(spanIdStr, -1L);
        short flags = NumberUtils.parseShort(this.requestAdaptor.getHeader(request, Header.HTTP_FLAGS.toString()), (short)0);
        return new ContinueTraceHeader(transactionId, parentSpanId, spanId, flags);
    }

    private boolean samplingEnable(T request) {
        String samplingFlag = this.requestAdaptor.getHeader(request, Header.HTTP_SAMPLED.toString());
        if (this.isDebug) {
            this.logger.debug("SamplingFlag={}", (Object)samplingFlag);
        }
        return SamplingFlagUtils.isSamplingFlag(samplingFlag);
    }
}

