/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.logging;

import com.navercorp.pinpoint.bootstrap.logging.DummyPLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerBinder;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;

public final class PLoggerFactory {
    private static PLoggerBinder loggerBinder;

    public static void initialize(PLoggerBinder loggerBinder) {
        if (PLoggerFactory.loggerBinder == null) {
            PLoggerFactory.loggerBinder = loggerBinder;
        } else {
            CommonLogger logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(PLoggerFactory.class.getName());
            logger.warn("loggerBinder is not null");
        }
    }

    public static void unregister(PLoggerBinder loggerBinder) {
        if (loggerBinder == PLoggerFactory.loggerBinder) {
            PLoggerFactory.loggerBinder = null;
        }
    }

    public static PLogger getLogger(String name) {
        if (loggerBinder == null) {
            return DummyPLogger.INSTANCE;
        }
        return loggerBinder.getLogger(name);
    }

    public static PLogger getLogger(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("class must not be null");
        }
        return PLoggerFactory.getLogger(clazz.getName());
    }
}

