/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operand;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.ClassUtils;

@InterfaceStability.Unstable
public class PackageInternalNameMatcherOperand
extends AbstractMatcherOperand {
    private final String packageInternalName;

    public PackageInternalNameMatcherOperand(String packageName) {
        Assert.requireNonNull((Object)packageName, (String)"packageName");
        this.packageInternalName = ClassUtils.toInternalName((String)packageName);
    }

    public String getPackageInternalName() {
        return this.packageInternalName;
    }

    public boolean match(String packageInternalName) {
        if (packageInternalName == null) {
            return false;
        }
        return packageInternalName.startsWith(this.packageInternalName);
    }

    @Override
    public int getExecutionCost() {
        return 3;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("packageInternalName=").append(this.packageInternalName);
        sb.append('}');
        return sb.toString();
    }
}

