/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HttpStatusCodeErrors {
    private static final StatusCode ALL_STATUS_CODES = new StatusCode(){

        @Override
        public boolean isCode(int statusCode) {
            return 100 <= statusCode && statusCode <= 599;
        }
    };
    private static final List<String> DEFAULT_ERROR_CODES = Arrays.asList("5xx");
    private final StatusCode[] errors;

    public HttpStatusCodeErrors() {
        this(DEFAULT_ERROR_CODES);
    }

    public HttpStatusCodeErrors(List<String> errorCodes) {
        this.errors = this.newErrorCode(errorCodes);
    }

    public boolean isHttpStatusCode(int statusCode) {
        return ALL_STATUS_CODES.isCode(statusCode);
    }

    public boolean isErrorCode(int statusCode) {
        for (StatusCode code : this.errors) {
            if (!code.isCode(statusCode)) continue;
            return true;
        }
        return false;
    }

    private StatusCode[] newErrorCode(List<String> errorCodes) {
        if (CollectionUtils.isEmpty(errorCodes)) {
            return new StatusCode[0];
        }
        ArrayList<StatusCode> statusCodeList = new ArrayList<StatusCode>();
        for (String errorCode : errorCodes) {
            if (errorCode.equalsIgnoreCase("5xx")) {
                statusCodeList.add(new ServerError());
                continue;
            }
            if (errorCode.equalsIgnoreCase("4xx")) {
                statusCodeList.add(new ClientError());
                continue;
            }
            if (errorCode.equalsIgnoreCase("3xx")) {
                statusCodeList.add(new Redirection());
                continue;
            }
            if (errorCode.equalsIgnoreCase("2xx")) {
                statusCodeList.add(new Success());
                continue;
            }
            if (errorCode.equalsIgnoreCase("1xx")) {
                statusCodeList.add(new Informational());
                continue;
            }
            try {
                int statusCode = Integer.parseInt(errorCode);
                statusCodeList.add(new DefaultStatusCode(statusCode));
            }
            catch (NumberFormatException ignored) {}
        }
        return this.toArray(statusCodeList);
    }

    private <T> StatusCode[] toArray(List<StatusCode> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new StatusCode[0];
        }
        return list.toArray(new StatusCode[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpStatusCodeErrors{");
        sb.append("errors=").append(Arrays.toString(this.errors));
        sb.append('}');
        return sb.toString();
    }

    private static class ServerError
    implements StatusCode {
        private ServerError() {
        }

        @Override
        public boolean isCode(int statusCode) {
            return 500 <= statusCode && statusCode <= 599;
        }

        public String toString() {
            return "5xx";
        }
    }

    private static class ClientError
    implements StatusCode {
        private ClientError() {
        }

        @Override
        public boolean isCode(int statusCode) {
            return 400 <= statusCode && statusCode <= 499;
        }

        public String toString() {
            return "4xx";
        }
    }

    private static class Redirection
    implements StatusCode {
        private Redirection() {
        }

        @Override
        public boolean isCode(int statusCode) {
            return 300 <= statusCode && statusCode <= 399;
        }

        public String toString() {
            return "3xx";
        }
    }

    private static class Success
    implements StatusCode {
        private Success() {
        }

        @Override
        public boolean isCode(int statusCode) {
            return 200 <= statusCode && statusCode <= 299;
        }

        public String toString() {
            return "2xx";
        }
    }

    private static class Informational
    implements StatusCode {
        private Informational() {
        }

        @Override
        public boolean isCode(int statusCode) {
            return 100 <= statusCode && statusCode <= 199;
        }

        public String toString() {
            return "1xx";
        }
    }

    private static class DefaultStatusCode
    implements StatusCode {
        private final int statusCode;

        public DefaultStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public boolean isCode(int statusCode) {
            return this.statusCode == statusCode;
        }

        public String toString() {
            return String.valueOf(this.statusCode);
        }
    }

    private static interface StatusCode {
        public boolean isCode(int var1);
    }
}

