/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jboss.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListenerInterceptorHelper;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.plugin.jboss.JbossConfig;
import com.navercorp.pinpoint.plugin.jboss.JbossConstants;
import com.navercorp.pinpoint.plugin.jboss.common.servlet.util.ArgumentValidator;
import com.navercorp.pinpoint.plugin.jboss.common.servlet.util.HttpServletRequestAdaptor;
import com.navercorp.pinpoint.plugin.jboss.common.servlet.util.ParameterRecorderFactory;
import com.navercorp.pinpoint.plugin.jboss.common.servlet.util.ServletArgumentValidator;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StandardHostValveInvokeInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final MethodDescriptor methodDescriptor;
    private final ArgumentValidator argumentValidator;
    private final ServletRequestListenerInterceptorHelper<HttpServletRequest> servletRequestListenerInterceptorHelper;

    public StandardHostValveInvokeInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.methodDescriptor = descriptor;
        this.argumentValidator = new ServletArgumentValidator(this.logger, 0, HttpServletRequest.class, 1, HttpServletResponse.class);
        JbossConfig config = new JbossConfig(traceContext.getProfilerConfig());
        HttpServletRequestAdaptor requestAdaptor = new HttpServletRequestAdaptor();
        requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport((RequestAdaptor)requestAdaptor, (String)config.getRealIpHeader(), (String)config.getRealIpEmptyValue());
        ParameterRecorder<HttpServletRequest> parameterRecorder = ParameterRecorderFactory.newParameterRecorderFactory(config.getExcludeProfileMethodFilter(), config.isTraceRequestParam());
        this.servletRequestListenerInterceptorHelper = new ServletRequestListenerInterceptorHelper(JbossConstants.JBOSS, traceContext, (RequestAdaptor)requestAdaptor, config.getExcludeUrlFilter(), parameterRecorder);
    }

    public void before(Object target, Object[] args) {
        block6: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if (!this.argumentValidator.validate(args)) {
                return;
            }
            try {
                HttpServletRequest request = (HttpServletRequest)args[0];
                if (request.isAsyncStarted() || request.getDispatcherType() == DispatcherType.ASYNC) {
                    if (this.isDebug) {
                        this.logger.debug("Skip async servlet request event. isAsyncStarted={}, dispatcherType={}", (Object)request.isAsyncStarted(), (Object)request.getDispatcherType());
                    }
                    return;
                }
                this.servletRequestListenerInterceptorHelper.initialized((Object)request, JbossConstants.JBOSS_METHOD, this.methodDescriptor);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block6;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block6: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if (!this.argumentValidator.validate(args)) {
                return;
            }
            try {
                HttpServletRequest request = (HttpServletRequest)args[0];
                HttpServletResponse response = (HttpServletResponse)args[1];
                if (request.getDispatcherType() == DispatcherType.ASYNC) {
                    if (this.isDebug) {
                        this.logger.debug("Skip async servlet request event. isAsyncStarted={}, dispatcherType={}", (Object)request.isAsyncStarted(), (Object)request.getDispatcherType());
                    }
                    return;
                }
                int statusCode = this.getStatusCode(response);
                this.servletRequestListenerInterceptorHelper.destroyed((Object)request, throwable, statusCode);
            }
            catch (Throwable t) {
                if (!this.isInfo) break block6;
                this.logger.info("Failed to servlet request event handle.", t);
            }
        }
    }

    private int getStatusCode(HttpServletResponse response) {
        try {
            return response.getStatus();
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

