/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.arcus.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AsyncContextSpanEventSimpleAroundInterceptor;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.arcus.ArcusConstants;
import com.navercorp.pinpoint.plugin.arcus.OperationAccessor;
import com.navercorp.pinpoint.plugin.arcus.ServiceCodeAccessor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.Operation;

public class FutureGetInterceptor
extends AsyncContextSpanEventSimpleAroundInterceptor {
    public FutureGetInterceptor(MethodDescriptor methodDescriptor, TraceContext traceContext) {
        super(traceContext, methodDescriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, AsyncContext asyncContext, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        String serviceCode;
        recorder.recordApi(this.methodDescriptor);
        recorder.recordDestinationId("MEMCACHED");
        recorder.recordServiceType(ArcusConstants.MEMCACHED_FUTURE_GET);
        if (!(target instanceof OperationAccessor)) {
            this.logger.info("operation not found");
            return;
        }
        Operation op = ((OperationAccessor)target)._$PINPOINT$_getOperation();
        if (op == null) {
            this.logger.info("operation is null");
            return;
        }
        recorder.recordException((Throwable)op.getException());
        MemcachedNode handlingNode = op.getHandlingNode();
        if (handlingNode != null) {
            String endPoint = this.getEndPoint(handlingNode);
            if (endPoint != null) {
                recorder.recordEndPoint(endPoint);
            }
            recorder.recordException((Throwable)op.getException());
        } else {
            this.logger.info("no handling node");
        }
        if (op instanceof ServiceCodeAccessor && (serviceCode = ((ServiceCodeAccessor)op)._$PINPOINT$_getServiceCode()) != null) {
            recorder.recordDestinationId(serviceCode);
            recorder.recordServiceType(ArcusConstants.ARCUS_FUTURE_GET);
        }
    }

    private String getEndPoint(MemcachedNode handlingNode) {
        SocketAddress socketAddress = handlingNode.getSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            String hostAddress = this.getHostAddress(inetSocketAddress);
            if (hostAddress == null) {
                this.logger.debug("hostAddress is null");
                return null;
            }
            return HostAndPort.toHostAndPortString((String)hostAddress, (int)inetSocketAddress.getPort());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("invalid socketAddress:{}", (Object)socketAddress);
        }
        return null;
    }

    private String getHostAddress(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }
}

