/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.arcus.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.arcus.ArcusConstants;
import com.navercorp.pinpoint.plugin.arcus.CacheNameAccessor;

public class FrontCacheGetFutureGetInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor methodDescriptor;
    private final TraceContext traceContext;

    public FrontCacheGetFutureGetInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
        this.traceContext = traceContext;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            String cacheName;
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            if (target instanceof CacheNameAccessor && (cacheName = ((CacheNameAccessor)target)._$PINPOINT$_getCacheName()) != null) {
                recorder.recordDestinationId(cacheName);
            }
            recorder.recordServiceType(ArcusConstants.ARCUS_EHCACHE_FUTURE_GET);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

