/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.lambda;

import com.navercorp.pinpoint.common.util.Assert;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInstReplacer
extends ClassVisitor {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String className;
    private final String methodName;
    private final String targetClassName;
    private final String targetMethodName;
    private final String delegateClassName;
    private final String delegateMethodName;
    private int transformCount = 0;

    public MethodInstReplacer(ClassVisitor classVisitor, String methodName, String targetClassName, String targetMethodName, String delegateClassName, String delegateMethodName) {
        super(458752, classVisitor);
        this.methodName = (String)Assert.requireNonNull((Object)methodName, (String)"methodName must not be null");
        this.targetClassName = (String)Assert.requireNonNull((Object)targetClassName, (String)"targetClassName must not be null");
        this.targetMethodName = (String)Assert.requireNonNull((Object)targetMethodName, (String)"targetMethodName must not be null");
        this.delegateClassName = (String)Assert.requireNonNull((Object)delegateClassName, (String)"delegateClassName must not be null");
        this.delegateMethodName = (String)Assert.requireNonNull((Object)delegateMethodName, (String)"delegateMethodName must not be null");
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.methodName.equals(name)) {
            this.logger.info("visitMethod {} desc:{} {}", (Object)name, (Object)descriptor);
            MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new MethodVisitor(458752, superMethodVisitor){

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    if (MethodInstReplacer.this.targetClassName.equals(owner) && MethodInstReplacer.this.targetMethodName.equals(name)) {
                        if (MethodInstReplacer.this.logger.isInfoEnabled()) {
                            MethodInstReplacer.this.logger.info("replace MethodInsn {}.{}() -> {}.{}()", new Object[]{owner, name, MethodInstReplacer.this.delegateClassName, MethodInstReplacer.this.delegateMethodName});
                        }
                        MethodInstReplacer.this.transformCount++;
                        super.visitMethodInsn(184, MethodInstReplacer.this.delegateClassName, MethodInstReplacer.this.delegateMethodName, descriptor, isInterface);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public String getClassName() {
        return this.className;
    }

    public int getTransformCount() {
        return this.transformCount;
    }
}

