/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resin;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class ResinConfig {
    private final boolean enable;
    private final String bootstrapMains;
    private final boolean hidePinpointHeader;
    private final boolean traceRequestParam;
    private final Filter<String> excludeUrlFilter;
    private final String realIpHeader;
    private final String realIpEmptyValue;
    private final Filter<String> excludeProfileMethodFilter;

    public ResinConfig(ProfilerConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.enable = config.readBoolean("profiler.resin.enable", true);
        this.bootstrapMains = config.readString("profiler.resin.bootstrap.main", "");
        this.traceRequestParam = config.readBoolean("profiler.resin.tracerequestparam", true);
        String resinExcludeURL = config.readString("profiler.resin.excludeurl", "");
        this.excludeUrlFilter = !resinExcludeURL.isEmpty() ? new ExcludePathFilter(resinExcludeURL) : new ExcludePathFilter("");
        this.realIpHeader = config.readString("profiler.resin.realipheader", null);
        this.realIpEmptyValue = config.readString("profiler.resin.realipemptyvalue", null);
        String resinExcludeProfileMethod = config.readString("profiler.resin.excludemethod", "");
        this.excludeProfileMethodFilter = !resinExcludeProfileMethod.isEmpty() ? new ExcludeMethodFilter(resinExcludeProfileMethod) : new ExcludeMethodFilter("");
        this.hidePinpointHeader = config.readBoolean("profiler.resin.hidepinpointheader", true);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getBootstrapMains() {
        return this.bootstrapMains;
    }

    public boolean isTraceRequestParam() {
        return this.traceRequestParam;
    }

    public Filter<String> getExcludeUrlFilter() {
        return this.excludeUrlFilter;
    }

    public String getRealIpHeader() {
        return this.realIpHeader;
    }

    public String getRealIpEmptyValue() {
        return this.realIpEmptyValue;
    }

    public Filter<String> getExcludeProfileMethodFilter() {
        return this.excludeProfileMethodFilter;
    }

    public boolean isHidePinpointHeader() {
        return this.hidePinpointHeader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResinConfig{");
        sb.append("enable=").append(this.enable);
        sb.append(", bootstrapMains='").append(this.bootstrapMains).append('\'');
        sb.append(", hidePinpointHeader=").append(this.hidePinpointHeader);
        sb.append(", traceRequestParam=").append(this.traceRequestParam);
        sb.append(", excludeUrlFilter=").append(this.excludeUrlFilter);
        sb.append(", realIpHeader='").append(this.realIpHeader).append('\'');
        sb.append(", realIpEmptyValue='").append(this.realIpEmptyValue).append('\'');
        sb.append(", excludeProfileMethodFilter=").append(this.excludeProfileMethodFilter);
        sb.append('}');
        return sb.toString();
    }
}

