/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.akka.http;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.akka.http.AkkaHttpConfig;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;

public class AkkaHttpPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        AkkaHttpConfig config = new AkkaHttpConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("Disable akka http plugin");
            return;
        }
        String transformTargetName = config.getTransformTargetName();
        List<String> transformTargetParameters = config.getTransformTargetParameters();
        if (StringUtils.isEmpty((String)transformTargetName)) {
            this.logger.warn("Not found 'profiler.akka.http.transform.targetname' in config");
        } else {
            try {
                String className = this.toClassName(transformTargetName);
                String methodName = this.toMethodName(transformTargetName);
                this.logger.info("Add request handler method for Akka HTTP Server. class={}, method={}", (Object)className, (Object)methodName);
                this.transformDirectives(className, methodName, transformTargetParameters);
                this.transformRequestContext();
                this.transformHttpRequest();
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("can't find target '{}' value={}", (Object)"profiler.akka.http.transform.targetname", (Object)transformTargetName);
            }
        }
    }

    private String toClassName(String fullQualifiedMethodName) {
        int classEndPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (classEndPosition <= 0) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(0, classEndPosition).trim();
    }

    private String toMethodName(String fullQualifiedMethodName) {
        int methodBeginPosition = fullQualifiedMethodName.lastIndexOf(46);
        if (methodBeginPosition <= 0 || methodBeginPosition + 1 >= fullQualifiedMethodName.length()) {
            throw new IllegalArgumentException("invalid full qualified method name(" + fullQualifiedMethodName + "). not found method");
        }
        return fullQualifiedMethodName.substring(methodBeginPosition + 1).trim();
    }

    private void transformDirectives(String clazzName, final String methodName, final List<String> methodParameters) {
        this.transformTemplate.transform(clazzName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{methodName}))) {
                    if (AkkaHttpPlugin.this.checkSuitableMethod(method, methodParameters)) {
                        AkkaHttpPlugin.this.logger.info("addInterceptor={}", Arrays.asList(method.getParameterTypes()));
                        method.addInterceptor("com.navercorp.pinpoint.plugin.akka.http.interceptor.DirectivesInterceptor");
                        continue;
                    }
                    AkkaHttpPlugin.this.logger.info("params={}", Arrays.asList(method.getParameterTypes()));
                }
                return target.toBytecode();
            }
        });
    }

    private boolean checkSuitableMethod(InstrumentMethod method, List<String> parameters) {
        if (method == null) {
            return false;
        }
        Object[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameters.size();
        if (ArrayUtils.getLength((Object[])parameterTypes) != parameterSize) {
            return false;
        }
        for (int i = 0; i < parameterSize; ++i) {
            if (((String)parameterTypes[i]).equals(parameters.get(i))) continue;
            return false;
        }
        return true;
    }

    private void transformRequestContext() {
        this.transformTemplate.transform("akka.http.scaladsl.server.RequestContextImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod completeMethod = target.getDeclaredMethod("complete", new String[]{"akka.http.scaladsl.marshalling.ToResponseMarshallable"});
                completeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.akka.http.interceptor.RequestContextImplCompleteInterceptor", "test", ExecutionPolicy.ALWAYS);
                InstrumentMethod redirectMethod = target.getDeclaredMethod("redirect", new String[]{"akka.http.scaladsl.model.Uri", "akka.http.scaladsl.model.StatusCodes$Redirection"});
                redirectMethod.addInterceptor("com.navercorp.pinpoint.plugin.akka.http.interceptor.RequestContextImplRedirectInterceptor");
                InstrumentMethod failMethod = target.getDeclaredMethod("fail", new String[]{"java.lang.Throwable"});
                failMethod.addInterceptor("com.navercorp.pinpoint.plugin.akka.http.interceptor.RequestContextImplFailInterceptor");
                InstrumentMethod copyMethod = target.getDeclaredMethod("copy", new String[]{"akka.http.scaladsl.model.HttpRequest", "akka.http.scaladsl.model.Uri$Path", "scala.concurrent.ExecutionContextExecutor", "akka.stream.Materializer", "akka.event.LoggingAdapter", "akka.http.scaladsl.settings.RoutingSettings", "akka.http.scaladsl.settings.ParserSettings"});
                copyMethod.addInterceptor("com.navercorp.pinpoint.plugin.akka.http.interceptor.RequestContextImplCopyInterceptor");
                return target.toBytecode();
            }
        });
    }

    private void transformHttpRequest() {
        this.transformTemplate.transform("akka.http.javadsl.model.HttpRequest", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

