/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.ning.asynchttpclient;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class NingAsyncHttpClientPluginConfig {
    private final boolean enable;
    private final boolean param;
    private final HttpDumpConfig httpDumpConfig;

    public NingAsyncHttpClientPluginConfig(ProfilerConfig src) {
        this.enable = src.readBoolean("profiler.ning.asynchttpclient", true);
        this.param = src.readBoolean("profiler.ning.asynchttpclient.param", false);
        boolean profileCookie = src.readBoolean("profiler.ning.asynchttpclient.cookie", false);
        DumpType cookieDumpType = src.readDumpType("profiler.ning.asynchttpclient.cookie.dumptype", DumpType.EXCEPTION);
        int cookieDumpSize = src.readInt("profiler.ning.asynchttpclient.cookie.dumpsize", 1024);
        int cookieSamplingRate = src.readInt("profiler.ning.asynchttpclient.cookie.sampling.rate", 1);
        boolean profileEntity = src.readBoolean("profiler.ning.asynchttpclient.entity", false);
        DumpType entityDumpType = src.readDumpType("profiler.ning.asynchttpclient.entity.dumptype", DumpType.EXCEPTION);
        int entityDumpSize = src.readInt("profiler.ning.asynchttpclient.entity.dumpsize", 1024);
        int entitySamplingRate = src.readInt("profiler.ning.asynchttpclient.entity.sampling.rate", 1);
        this.httpDumpConfig = HttpDumpConfig.get((boolean)profileCookie, (DumpType)cookieDumpType, (int)cookieSamplingRate, (int)cookieDumpSize, (boolean)profileEntity, (DumpType)entityDumpType, (int)entitySamplingRate, (int)entityDumpSize);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isParam() {
        return this.param;
    }

    public HttpDumpConfig getHttpDumpConfig() {
        return this.httpDumpConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NingAsyncHttpClientPluginConfig{");
        sb.append("enable=").append(this.enable);
        sb.append(", param=").append(this.param);
        sb.append(", httpDumpConfig=").append(this.httpDumpConfig);
        sb.append('}');
        return sb.toString();
    }
}

