/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import com.navercorp.pinpoint.profiler.sender.SpanStreamSendData;
import com.navercorp.pinpoint.profiler.sender.StandbySpanStreamDataFlushHandler;
import com.navercorp.pinpoint.profiler.sender.StandbySpanStreamDataStorage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbySpanStreamDataSendWorker
implements Runnable {
    private static final long DEFAULT_BLOCK_TIME = 1000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StandbySpanStreamDataFlushHandler flushHandler;
    private final StandbySpanStreamDataStorage standbySpanStreamDataStorage;
    private final long blockTime;
    private final Object lock = new Object();
    private Thread workerThread;
    private boolean isStarted = false;

    public StandbySpanStreamDataSendWorker(StandbySpanStreamDataFlushHandler flushHandler, StandbySpanStreamDataStorage dataStorage) {
        this(flushHandler, dataStorage, 1000L);
    }

    public StandbySpanStreamDataSendWorker(StandbySpanStreamDataFlushHandler flushHandler, StandbySpanStreamDataStorage dataStorage, long blockTime) {
        this.flushHandler = flushHandler;
        this.standbySpanStreamDataStorage = dataStorage;
        this.blockTime = blockTime;
    }

    public void start() {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory(this.getClass().getSimpleName(), true);
        this.workerThread = threadFactory.newThread(this);
        this.logger.info("start() started.");
        if (!this.workerThread.isAlive()) {
            this.isStarted = true;
            this.workerThread.start();
            this.logger.info("start() completed.");
        } else {
            this.logger.info("start() failed. caused:already started.", (Object)this.getClass().getSimpleName());
        }
    }

    public void stop() {
        this.logger.info("stop() started.");
        this.isStarted = false;
        long startTimeMillis = System.currentTimeMillis();
        long maxWaitTimeMillis = 3000L;
        while (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            try {
                this.workerThread.join(100L);
                if (System.currentTimeMillis() - startTimeMillis <= maxWaitTimeMillis) continue;
                break;
            }
            catch (InterruptedException ignored) {
            }
        }
        this.logger.info("stop() completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addStandbySpanStreamData(SpanStreamSendData standbySpanStreamData) {
        Object object = this.lock;
        synchronized (object) {
            boolean isAdded = this.standbySpanStreamDataStorage.addStandbySpanStreamData(standbySpanStreamData);
            this.lock.notifyAll();
            return isAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpanStreamSendData getStandbySpanStreamSendData(int availableCapacity) {
        Object object = this.lock;
        synchronized (object) {
            return this.standbySpanStreamDataStorage.getStandbySpanStreamSendData(availableCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpanStreamSendData getStandbySpanStreamSendData() {
        Object object = this.lock;
        synchronized (object) {
            return this.standbySpanStreamDataStorage.getStandbySpanStreamSendData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SpanStreamSendData> getForceFlushSpanStreamDataList() {
        Object object = this.lock;
        synchronized (object) {
            return this.standbySpanStreamDataStorage.getForceFlushSpanStreamDataList();
        }
    }

    @Override
    public void run() {
        while (this.isStarted) {
            boolean onEvent = this.await();
            if (!this.isStarted) break;
            List<SpanStreamSendData> forceFlushSpanStreamDataList = this.getForceFlushSpanStreamDataList();
            this.forceFlush(forceFlushSpanStreamDataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await() {
        Object object = this.lock;
        synchronized (object) {
            long timeBlocked = this.standbySpanStreamDataStorage.getLeftWaitTime(this.blockTime);
            long startTimeMillis = System.currentTimeMillis();
            if (timeBlocked > 0L) {
                try {
                    this.lock.wait(timeBlocked);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (this.isOverWaitTime(timeBlocked, startTimeMillis)) {
                    return false;
                }
            }
            return true;
        }
    }

    private boolean isOverWaitTime(long waitTimeMillis, long startTimeMillis) {
        return waitTimeMillis < System.currentTimeMillis() - startTimeMillis;
    }

    private void forceFlush(List<SpanStreamSendData> forceFlushSpanStreamDataList) {
        if (forceFlushSpanStreamDataList == null) {
            return;
        }
        for (SpanStreamSendData spanStreamSendData : forceFlushSpanStreamDataList) {
            try {
                this.flushHandler.handleFlush(spanStreamSendData);
            }
            catch (Exception e) {
                this.flushHandler.exceptionCaught(spanStreamSendData, e);
            }
        }
    }
}

