/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.receiver.service.StackTrace;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadLightDump;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ThreadDumpRequest {
    static final int MAX_THREAD_DUMP_LIMIT = 2048;
    private final Set<Long> localTransactionIdSet;
    private final Set<String> threadNameSet;
    private final int limit;
    private final boolean enableFilter;
    private final boolean localTransactionIdFilter;
    private final boolean threadNameFilter;
    private final StackTrace stackTrace;

    public static ThreadDumpRequest create(TCmdActiveThreadDump request) {
        Assert.requireNonNull((Object)request, (String)"request must not be null");
        int limit = ThreadDumpRequest.getLimit(request.getLimit());
        List localTransactionIdList = request.getLocalTraceIdList();
        List threadNameList = request.getThreadNameList();
        return new ThreadDumpRequest(StackTrace.DUMP, limit, localTransactionIdList, threadNameList);
    }

    public static ThreadDumpRequest create(TCmdActiveThreadLightDump request) {
        Assert.requireNonNull((Object)request, (String)"request must not be null");
        int limit = ThreadDumpRequest.getLimit(request.getLimit());
        List localTransactionIdList = request.getLocalTraceIdList();
        List threadNameList = request.getThreadNameList();
        return new ThreadDumpRequest(StackTrace.SKIP, limit, localTransactionIdList, threadNameList);
    }

    ThreadDumpRequest(StackTrace stackTrace, int limit, List<Long> localTransactionIdList, List<String> threadNameList) {
        this.stackTrace = (StackTrace)((Object)Assert.requireNonNull((Object)((Object)stackTrace), (String)"stackTrace must not be null"));
        this.limit = limit;
        this.localTransactionIdSet = this.newHashSet(localTransactionIdList);
        this.localTransactionIdFilter = CollectionUtils.hasLength(this.localTransactionIdSet);
        this.threadNameSet = this.newHashSet(threadNameList);
        this.threadNameFilter = CollectionUtils.hasLength(this.threadNameSet);
        this.enableFilter = this.isEnableFilter(this.localTransactionIdFilter, this.threadNameFilter);
    }

    private boolean isEnableFilter(boolean localTransactionIdFilter, boolean threadNameFilter) {
        if (localTransactionIdFilter) {
            return true;
        }
        return threadNameFilter;
    }

    @VisibleForTesting
    static int getLimit(int limit) {
        if (0 >= limit) {
            return 2048;
        }
        return Math.min(limit, 2048);
    }

    private <T> Set<T> newHashSet(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptySet();
        }
        return new HashSet<T>(list);
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isEnableFilter() {
        return this.enableFilter;
    }

    public boolean isEnableLocalTransactionIdFilter() {
        return this.localTransactionIdFilter;
    }

    public boolean findLocalTransactionId(long localTransactionId) {
        return this.localTransactionIdSet.contains(localTransactionId);
    }

    public boolean isEnableThreadNameFilter() {
        return this.threadNameFilter;
    }

    public boolean findThreadName(String threadName) {
        return this.threadNameSet.contains(threadName);
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }
}

