/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.receiver.ProfilerRequestCommandService;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadDumpCoreService;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDump;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDumpRequest;
import com.navercorp.pinpoint.profiler.util.ThreadDumpUtils;
import com.navercorp.pinpoint.thrift.dto.command.TActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TCmdActiveThreadDumpRes;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDump;
import com.navercorp.pinpoint.thrift.io.TCommandType;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.thrift.TBase;

public class ActiveThreadDumpService
implements ProfilerRequestCommandService<TBase<?, ?>, TBase<?, ?>> {
    static final String JAVA = "JAVA";
    private final ActiveThreadDumpCoreService activeThreadDumpCoreService;

    public ActiveThreadDumpService(ActiveThreadDumpCoreService activeThreadDumpCoreService) {
        this.activeThreadDumpCoreService = activeThreadDumpCoreService;
    }

    @Override
    public TBase<?, ?> requestCommandService(TBase tBase) {
        TCmdActiveThreadDump request = (TCmdActiveThreadDump)tBase;
        List<TActiveThreadDump> activeThreadDumpList = this.getActiveThreadDumpList(request);
        TCmdActiveThreadDumpRes response = new TCmdActiveThreadDumpRes();
        response.setType(JAVA);
        response.setSubType(JvmUtils.getType().name());
        response.setVersion(JvmUtils.getVersion().name());
        response.setThreadDumps(activeThreadDumpList);
        return response;
    }

    private List<TActiveThreadDump> getActiveThreadDumpList(TCmdActiveThreadDump tRequest) {
        ThreadDumpRequest request = ThreadDumpRequest.create(tRequest);
        Collection<ThreadDump> activeThreadDumpList = this.activeThreadDumpCoreService.getActiveThreadDumpList(request);
        return this.toTActiveThreadDump(activeThreadDumpList);
    }

    private List<TActiveThreadDump> toTActiveThreadDump(Collection<ThreadDump> activeTraceInfoList) {
        ArrayList<TActiveThreadDump> result = new ArrayList<TActiveThreadDump>(activeTraceInfoList.size());
        for (ThreadDump threadDump : activeTraceInfoList) {
            TActiveThreadDump tActiveThreadDump = this.createTActiveThreadDump(threadDump);
            result.add(tActiveThreadDump);
        }
        return result;
    }

    private TActiveThreadDump createTActiveThreadDump(ThreadDump threadDump) {
        ActiveTraceSnapshot activeTraceInfo = threadDump.getActiveTraceSnapshot();
        ThreadInfo threadInfo = threadDump.getThreadInfo();
        TThreadDump tThreadDump = ThreadDumpUtils.createTThreadDump(threadInfo);
        TActiveThreadDump activeThreadDump = new TActiveThreadDump();
        activeThreadDump.setStartTime(activeTraceInfo.getStartTime());
        activeThreadDump.setLocalTraceId(activeTraceInfo.getLocalTransactionId());
        activeThreadDump.setThreadDump(tThreadDump);
        if (activeTraceInfo.isSampled()) {
            activeThreadDump.setSampled(true);
            activeThreadDump.setTransactionId(activeTraceInfo.getTransactionId());
            activeThreadDump.setEntryPoint(activeTraceInfo.getEntryPoint());
        }
        return activeThreadDump;
    }

    @Override
    public short getCommandServiceCode() {
        return TCommandType.ACTIVE_THREAD_DUMP.getCode();
    }
}

