/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver;

import com.navercorp.pinpoint.profiler.receiver.DefaultProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceGroup;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerCommandLocatorBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Short, ProfilerCommandService> profilerCommandServiceRepository = new HashMap<Short, ProfilerCommandService>();

    public void addService(ProfilerCommandServiceGroup serviceGroup) {
        if (serviceGroup == null) {
            throw new NullPointerException("serviceGroup must not be null");
        }
        for (ProfilerCommandService service : serviceGroup.getCommandServiceList()) {
            this.addService(service);
        }
    }

    public boolean addService(ProfilerCommandService service) {
        if (service == null) {
            throw new NullPointerException("service must not be null");
        }
        return this.addService(service.getCommandServiceCode(), service);
    }

    boolean addService(short commandCode, ProfilerCommandService service) {
        if (service == null) {
            throw new NullPointerException("service must not be null");
        }
        ProfilerCommandService exist = this.profilerCommandServiceRepository.get(commandCode);
        if (exist != null) {
            this.logger.warn("Already Register CommandCode:{}, RegisteredService:{}.", (Object)commandCode, (Object)exist);
            return false;
        }
        this.profilerCommandServiceRepository.put(commandCode, service);
        return true;
    }

    public ProfilerCommandServiceLocator build() {
        return new DefaultProfilerCommandServiceLocator(this);
    }

    protected Map<Short, ProfilerCommandService> getProfilerCommandServiceRepository() {
        return this.profilerCommandServiceRepository;
    }
}

