/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver;

import com.google.inject.Inject;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.profiler.receiver.CommandSerializer;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.ProfilerRequestCommandService;
import com.navercorp.pinpoint.profiler.receiver.ProfilerStreamCommandService;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import java.io.Closeable;
import java.util.Set;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDispatcher
implements MessageListener,
ServerStreamChannelMessageListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerCommandServiceLocator<TBase<?, ?>, TBase<?, ?>> commandServiceLocator;

    @Inject
    public CommandDispatcher(ProfilerCommandServiceLocator<TBase<?, ?>, TBase<?, ?>> commandServiceLocator) {
        this.commandServiceLocator = (ProfilerCommandServiceLocator)Assert.requireNonNull(commandServiceLocator, (String)"commandServiceLocator must not be null");
    }

    public void handleSend(SendPacket sendPacket, PinpointSocket pinpointSocket) {
        this.logger.info("handleSend packet:{}, remote:{}", (Object)sendPacket, (Object)pinpointSocket.getRemoteAddress());
    }

    public void handleRequest(RequestPacket requestPacket, PinpointSocket pinpointSocket) {
        TBase<?, ?> response;
        byte[] payload;
        this.logger.info("handleRequest packet:{}, remote:{}", (Object)requestPacket, (Object)pinpointSocket.getRemoteAddress());
        Message message = SerializationUtils.deserialize((byte[])requestPacket.getPayload(), CommandSerializer.DESERIALIZER_FACTORY, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("handleRequest request:{}, remote:{}", (Object)message, (Object)pinpointSocket.getRemoteAddress());
        }
        if ((payload = SerializationUtils.serialize(response = this.processRequest(message), CommandSerializer.SERIALIZER_FACTORY, null)) != null) {
            pinpointSocket.response(requestPacket.getRequestId(), payload);
        }
    }

    private TBase<?, ?> processRequest(Message<TBase<?, ?>> message) {
        if (message == null) {
            TResult tResult = new TResult(false);
            tResult.setMessage("Unsupported ServiceTypeInfo.");
            return tResult;
        }
        short type = message.getHeader().getType();
        ProfilerRequestCommandService<TBase<?, ?>, TBase<?, ?>> service = this.commandServiceLocator.getRequestService(type);
        if (service == null) {
            TResult tResult = new TResult(false);
            tResult.setMessage("Can't find suitable service(" + message + ").");
            return tResult;
        }
        TBase request = (TBase)message.getData();
        TBase<?, ?> tResponse = service.requestCommandService(request);
        return tResponse;
    }

    public StreamCode handleStreamCreate(ServerStreamChannelContext streamChannelContext, StreamCreatePacket packet) {
        this.logger.info("MessageReceived handleStreamCreate {} {}", (Object)packet, (Object)streamChannelContext);
        Message message = SerializationUtils.deserialize((byte[])packet.getPayload(), CommandSerializer.DESERIALIZER_FACTORY, null);
        if (message == null) {
            return StreamCode.TYPE_UNKNOWN;
        }
        short type = message.getHeader().getType();
        ProfilerStreamCommandService<TBase<?, ?>> service = this.commandServiceLocator.getStreamService(type);
        if (service == null) {
            return StreamCode.TYPE_UNSUPPORT;
        }
        TBase request = (TBase)message.getData();
        return service.streamCommandService(request, streamChannelContext);
    }

    public void handleStreamClose(ServerStreamChannelContext streamChannelContext, StreamClosePacket packet) {
    }

    public Set<Short> getRegisteredCommandServiceCodes() {
        return this.commandServiceLocator.getCommandServiceCodes();
    }

    public void close() {
        this.logger.info("close() started");
        Set<Short> commandServiceCodes = this.commandServiceLocator.getCommandServiceCodes();
        for (Short commandServiceCode : commandServiceCodes) {
            ProfilerCommandService service = this.commandServiceLocator.getService(commandServiceCode);
            if (!(service instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)service)).close();
            }
            catch (Exception e) {
                this.logger.warn("failed to close for CommandService:{}. message:{}", (Object)service, (Object)e.getMessage());
            }
        }
        this.logger.info("close() completed");
    }

    public String toString() {
        return "CommandDispatcher{" + this.commandServiceLocator.getCommandServiceCodes() + '}';
    }
}

