/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.monitor.AgentStatMonitor;
import com.navercorp.pinpoint.profiler.monitor.CollectJob;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.EmptyDataSender;
import com.navercorp.pinpoint.thrift.dto.TAgentStat;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgentStatMonitor
implements AgentStatMonitor {
    private static final long MIN_COLLECTION_INTERVAL_MS = 1000L;
    private static final long MAX_COLLECTION_INTERVAL_MS = 5000L;
    private static final long DEFAULT_COLLECTION_INTERVAL_MS = 5000L;
    private static final int DEFAULT_NUM_COLLECTIONS_PER_SEND = 6;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long collectionIntervalMs;
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new PinpointThreadFactory("Pinpoint-stat-monitor", true));
    private final CollectJob collectJob;

    @Inject
    public DefaultAgentStatMonitor(@StatDataSender DataSender dataSender, @AgentId String agentId, @AgentStartTime long agentStartTimestamp, @Named(value="AgentStatCollector") AgentStatMetricCollector<TAgentStat> agentStatCollector, ProfilerConfig profilerConfig) {
        this(dataSender, agentId, agentStartTimestamp, agentStatCollector, profilerConfig.getProfileJvmStatCollectIntervalMs(), profilerConfig.getProfileJvmStatBatchSendCount());
    }

    public DefaultAgentStatMonitor(DataSender dataSender, String agentId, long agentStartTimestamp, AgentStatMetricCollector<TAgentStat> agentStatCollector, long collectionIntervalMs, int numCollectionsPerBatch) {
        if (dataSender == null) {
            throw new NullPointerException("dataSender must not be null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId must not be null");
        }
        if (agentStatCollector == null) {
            throw new NullPointerException("agentStatCollector must not be null");
        }
        if (collectionIntervalMs < 1000L) {
            collectionIntervalMs = 5000L;
        }
        if (collectionIntervalMs > 5000L) {
            collectionIntervalMs = 5000L;
        }
        if (numCollectionsPerBatch < 1) {
            numCollectionsPerBatch = 6;
        }
        this.collectionIntervalMs = collectionIntervalMs;
        this.collectJob = new CollectJob(dataSender, agentId, agentStartTimestamp, agentStatCollector, numCollectionsPerBatch);
        this.preLoadClass(agentId, agentStartTimestamp, agentStatCollector);
    }

    private void preLoadClass(String agentId, long agentStartTimestamp, AgentStatMetricCollector<TAgentStat> agentStatCollector) {
        this.logger.debug("pre-load class start");
        CollectJob collectJob = new CollectJob(EmptyDataSender.INSTANCE, agentId, agentStartTimestamp, agentStatCollector, 1);
        collectJob.run();
        collectJob.run();
        this.logger.debug("pre-load class end");
    }

    @Override
    public void start() {
        this.executor.scheduleAtFixedRate(this.collectJob, this.collectionIntervalMs, this.collectionIntervalMs, TimeUnit.MILLISECONDS);
        this.logger.info("AgentStat monitor started");
    }

    @Override
    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.logger.info("AgentStat monitor stopped");
    }
}

