/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.google.inject.Inject;
import com.navercorp.pinpoint.profiler.metadata.Result;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;

public class DefaultStringMetaDataService
implements StringMetaDataService {
    private final SimpleCache<String> stringCache = new SimpleCache();
    private final EnhancedDataSender<Object> enhancedDataSender;

    @Inject
    public DefaultStringMetaDataService(EnhancedDataSender<Object> enhancedDataSender) {
        if (enhancedDataSender == null) {
            throw new NullPointerException("enhancedDataSender must not be null");
        }
        this.enhancedDataSender = enhancedDataSender;
    }

    @Override
    public int cacheString(String value) {
        if (value == null) {
            return 0;
        }
        Result result = this.stringCache.put(value);
        if (result.isNewValue()) {
            StringMetaData stringMetaData = new StringMetaData(result.getId(), value);
            this.enhancedDataSender.request(stringMetaData);
        }
        return result.getId();
    }
}

