/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.lambda;

import com.navercorp.pinpoint.bootstrap.instrument.lambda.LambdaBytecodeHandler;
import com.navercorp.pinpoint.bootstrap.module.ClassFileTransformModuleAdaptor;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import com.navercorp.pinpoint.common.util.Assert;
import java.security.ProtectionDomain;
import org.slf4j.LoggerFactory;

public class DefaultLambdaBytecodeHandler
implements LambdaBytecodeHandler {
    private final JavaModuleFactory javaModuleFactory;
    private final ClassFileTransformModuleAdaptor classFileTransformer;

    public DefaultLambdaBytecodeHandler(ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        this.classFileTransformer = (ClassFileTransformModuleAdaptor)Assert.requireNonNull((Object)classFileTransformer, (String)"classFileTransformer must not be null");
        this.javaModuleFactory = (JavaModuleFactory)Assert.requireNonNull((Object)javaModuleFactory, (String)"javaModuleFactory must not be null");
    }

    public byte[] handleLambdaBytecode(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        try {
            ClassLoader classLoader = hostClass.getClassLoader();
            Object module = this.javaModuleFactory.getModule(hostClass);
            ProtectionDomain protectionDomain = hostClass.getProtectionDomain();
            byte[] transform = this.classFileTransformer.transform(module, classLoader, null, null, protectionDomain, data);
            if (transform != null) {
                return transform;
            }
            return data;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("lambda transform fail Caused by:" + e.getMessage(), (Throwable)e);
            return data;
        }
    }
}

