/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.scope;

import com.navercorp.pinpoint.profiler.context.scope.Pool;
import com.navercorp.pinpoint.profiler.context.scope.PoolObjectFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentPool<K, V>
implements Pool<K, V> {
    private final ConcurrentMap<K, V> pool = new ConcurrentHashMap();
    private final PoolObjectFactory<K, V> objectFactory;

    public ConcurrentPool(PoolObjectFactory<K, V> objectFactory) {
        if (objectFactory == null) {
            throw new NullPointerException("objectFactory must not be null");
        }
        this.objectFactory = objectFactory;
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Object alreadyExist = this.pool.get(key);
        if (alreadyExist != null) {
            return alreadyExist;
        }
        V newValue = this.objectFactory.create(key);
        V oldValue = this.pool.putIfAbsent(key, newValue);
        if (oldValue != null) {
            return oldValue;
        }
        return newValue;
    }
}

