/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import com.navercorp.pinpoint.profiler.context.module.SpanStatChannelFactory;
import com.navercorp.pinpoint.profiler.context.module.SpanStatConnectTimer;
import com.navercorp.pinpoint.profiler.context.provider.AbstractClientFactoryProvider;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;

public class StatClientFactoryProvider
extends AbstractClientFactoryProvider
implements Provider<PinpointClientFactory> {
    private final ProfilerConfig profilerConfig;
    private final Provider<ChannelFactory> channelFactoryProvider;
    private final Provider<Timer> spanStatConnectTimer;

    @Inject
    public StatClientFactoryProvider(ProfilerConfig profilerConfig, @SpanStatChannelFactory Provider<ChannelFactory> channelFactoryProvider, @SpanStatConnectTimer Provider<Timer> spanStatConnectTimer) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.channelFactoryProvider = (Provider)Assert.requireNonNull(channelFactoryProvider, (String)"channelFactoryProvider must not be null");
        this.spanStatConnectTimer = (Provider)Assert.requireNonNull(spanStatConnectTimer, (String)"spanStatConnectTimer must not be null");
    }

    public PinpointClientFactory get() {
        if (!"TCP".equalsIgnoreCase(this.profilerConfig.getStatDataSenderTransportType())) {
            return null;
        }
        DefaultPinpointClientFactory pinpointClientFactory = new DefaultPinpointClientFactory((ChannelFactory)this.channelFactoryProvider.get(), (Timer)this.spanStatConnectTimer.get());
        pinpointClientFactory.setWriteTimeoutMillis(3000L);
        pinpointClientFactory.setRequestTimeoutMillis(5000L);
        int writeBufferHighWaterMark = this.getByteSize(this.profilerConfig.getStatDataSenderWriteBufferHighWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(16L));
        int writeBufferLowWaterMark = this.getByteSize(this.profilerConfig.getStatDataSenderWriteBufferLowWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(8L));
        if (writeBufferLowWaterMark > writeBufferHighWaterMark) {
            this.logger.warn("must be writeBufferHighWaterMark({}) >= writeBufferLowWaterMark({})", (Object)writeBufferHighWaterMark, (Object)writeBufferLowWaterMark);
            writeBufferLowWaterMark = writeBufferHighWaterMark;
        }
        pinpointClientFactory.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        pinpointClientFactory.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return pinpointClientFactory;
    }
}

