/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.SystemPropertyKey;
import com.navercorp.pinpoint.profiler.JvmInformation;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.JvmGcType;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.UnknownGarbageCollectorMetric;

public class JvmInformationProvider
implements Provider<JvmInformation> {
    private final String jvmVersion = JvmUtils.getSystemProperty((SystemPropertyKey)SystemPropertyKey.JAVA_VERSION);
    private final GarbageCollectorMetric garbageCollectorMetric;

    @Inject
    public JvmInformationProvider(GarbageCollectorMetric garbageCollectorMetric) {
        this.garbageCollectorMetric = garbageCollectorMetric;
    }

    public JvmInformationProvider() {
        this(new UnknownGarbageCollectorMetric());
    }

    public JvmInformation get() {
        JvmGcType gcType = this.garbageCollectorMetric.getGcType();
        return new JvmInformation(this.jvmVersion, gcType.getValue());
    }
}

