/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.javamodule;

import com.navercorp.pinpoint.bootstrap.module.JavaModule;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;

public final class JavaModuleFactoryFinder {
    private JavaModuleFactoryFinder() {
    }

    public static JavaModuleFactory lookup(Instrumentation instrumentation) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        Class<JavaModuleFactory> javaModuleFactory = JavaModuleFactoryFinder.getJavaModuleFactory();
        try {
            Constructor<JavaModuleFactory> constructor = javaModuleFactory.getDeclaredConstructor(Instrumentation.class);
            return constructor.newInstance(instrumentation);
        }
        catch (Exception e) {
            throw new IllegalStateException("JavaModuleFactory() invoke fail Caused by:" + e.getMessage(), e);
        }
    }

    private static Class<JavaModuleFactory> getJavaModuleFactory() {
        String factoryName = "com.navercorp.pinpoint.bootstrap.java9.module.DefaultJavaModuleFactory";
        try {
            return Class.forName("com.navercorp.pinpoint.bootstrap.java9.module.DefaultJavaModuleFactory", false, JavaModule.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("com.navercorp.pinpoint.bootstrap.java9.module.DefaultJavaModuleFactory not found");
        }
    }
}

