/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.active.ActiveTrace;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.active.SampledActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;

public class SampledActiveTrace
implements ActiveTrace {
    private final TraceRoot traceRoot;

    public SampledActiveTrace(TraceRoot traceRoot) {
        this.traceRoot = (TraceRoot)Assert.requireNonNull((Object)traceRoot, (String)"trace must not be null");
    }

    @Override
    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    @Override
    public long getId() {
        return this.traceRoot.getLocalTransactionId();
    }

    @Override
    public ActiveTraceSnapshot snapshot() {
        return new SampledActiveTraceSnapshot(this.traceRoot);
    }

    public String toString() {
        return "SampledActiveTrace{traceRoot=" + this.traceRoot + '}';
    }
}

